package logicirc.core;

/**
 * ͂Q_H̃XPgłB <br>
 * ͂ւ̐ڑ𑀍삷邽߂̃RXgN^ƃ\bh`Ă܂B
 */
public abstract class AbstractDoubleInputCircuit implements DoubleInputCircuit {

    /** AɐڑĂ_H */
    protected LogicalCircuit inputA = Voltage.LOW;

    /** BɐڑĂ_H */
    protected LogicalCircuit inputB = Voltage.LOW;

    /**
     * _H𐶐܂B ftHgƂāAA,B <code>Voltage.LOW</code> ݒ肳܂B
     */
    public AbstractDoubleInputCircuit() {

    }

    /**
     * _H𐶐܂B
     * @param a A <code>Voltage.HIGH</code> ݒ肷ꍇ <code>true</code>A
     *            <code>Voltage.LOW</code> ݒ肷ꍇ <code>false</code>
     * @param b B <code>Voltage.HIGH</code> ݒ肷ꍇ <code>true</code>A
     *            <code>Voltage.LOW</code> ݒ肷ꍇ <code>false</code>
     */
    public AbstractDoubleInputCircuit(boolean a, boolean b) {

        inputA = (a ? Voltage.HIGH : Voltage.LOW);
        inputB = (b ? Voltage.HIGH : Voltage.LOW);

    }

    /**
     * _H𐶐܂B
     * @param lcA Aɐڑ_H
     * @param lcB Bɐڑ_H
     */
    public AbstractDoubleInputCircuit(LogicalCircuit lcA, LogicalCircuit lcB) {

        inputA = lcA;
        inputB = lcB;

    }

    /**
     * Aɘ_Hȉójڑ܂B
     * @param lc ڑ_H
     */
    public final void setInputA(LogicalCircuit lc) {

        inputA = lc;

    }

    /**
     * Bɘ_Hȉójڑ܂B
     * @param lc ڑ_H
     */
    public final void setInputB(LogicalCircuit lc) {

        inputB = lc;

    }

}