package logicirc.view;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import logicirc.core.CircuitAdapter;
import logicirc.core.DoubleInputCircuit;
import logicirc.core.DoubleInputSocket;
import logicirc.core.LogicalCircuit;
import logicirc.core.Voltage;

/**
 * HՂłB
 */
public final class CircuitBoard {

    private DoubleInputSocket[] sockets;
    private CircuitAdapter[][] adapters;
    private CircuitAdapter lastAdapter;
    private CircuitAdapter[] bypass;
    private List listeners;
    
    /**
     * HՂ𐶐܂B
     */
    public CircuitBoard() {

        listeners = new LinkedList();

        // \PbgƔz̏
        adapters = new CircuitAdapter[7][];
        for (int i = 0; i < adapters.length; i++) {
            adapters[i] = new CircuitAdapter[2];
            for (int j = 0; j < adapters[i].length; j++) {
                adapters[i][j] = new CircuitAdapter();
            }
        }
        lastAdapter = new CircuitAdapter();
        sockets = new DoubleInputSocket[7];
        sockets[0] = new DoubleInputSocket(adapters[0][0], adapters[0][1],
                adapters[4][0]);
        sockets[1] = new DoubleInputSocket(adapters[1][0], adapters[1][1],
                adapters[4][1]);
        sockets[2] = new DoubleInputSocket(adapters[2][0], adapters[2][1],
                adapters[5][0]);
        sockets[3] = new DoubleInputSocket(adapters[3][0], adapters[3][1],
                adapters[5][1]);
        sockets[4] = new DoubleInputSocket(adapters[4][0], adapters[4][1],
                adapters[6][0]);
        sockets[5] = new DoubleInputSocket(adapters[5][0], adapters[5][1],
                adapters[6][1]);
        sockets[6] = new DoubleInputSocket(adapters[6][0], adapters[6][1],
                lastAdapter);

        // ŏ̓͂̏lݒ
        adapters[0][0].setInput(Voltage.LOW);
        adapters[0][1].setInput(Voltage.LOW);
        adapters[1][0].setInput(Voltage.LOW);
        adapters[1][1].setInput(Voltage.LOW);
        adapters[2][0].setInput(Voltage.LOW);
        adapters[2][1].setInput(Voltage.HIGH);
        adapters[3][0].setInput(Voltage.HIGH);
        adapters[3][1].setInput(Voltage.LOW);

        // o͂oCpXA_v^̐ݒ
        bypass = new CircuitAdapter[7];
        for (int i = 0; i < bypass.length; i++) {
            bypass[i] = new CircuitAdapter();
        }
        bypass[0].setInput(adapters[4][0]);
        bypass[1].setInput(adapters[4][1]);
        bypass[2].setInput(adapters[5][0]);
        bypass[3].setInput(adapters[5][1]);
        bypass[4].setInput(adapters[6][0]);
        bypass[5].setInput(adapters[6][1]);
        bypass[6].setInput(lastAdapter);

    }

    /**
     * HՂ̏ԕύXĎ郊Xio^܂B
     * @param listener Xi
     */
    public void addBoardStateListener(BoardStateListener listener) {

        listeners.add(listener);

    }

    /**
     * HՂ̏ԕύXXiɒʒm܂B
     */
    public void fireChangeState() {

        BoardStateEvent event = new BoardStateEvent(this);
        for (Iterator it = listeners.iterator(); it.hasNext();) {
            BoardStateListener listener = (BoardStateListener)it.next();
            if (listener != null) {
                listener.stateChanged(event);
            }
        }

    }

    /**
     * _H̏o͂擾܂B
     * @param index _H̔ԍ(1`7)
     * @return <code>1</code> Ȃ <code>true</code>A<code>0</code> Ȃ
     *         <code>false</code>
     */
    public boolean getOutput(int index) {

        return bypass[index].getOutput();

    }

    /**
     * HA_v^擾܂B
     * @param first _H̔ԍ(1`7)
     * @param second ÃA_v^ <code>0</code>A B̃A_v^ <code>1</code>
     * @return HA_v^
     */
    public CircuitAdapter getAdapter(int first, int second) {

        return adapters[first][second];

    }

    /**
     * _H擾܂B
     * @param index _H̔ԍ(1`7)
     * @return _H
     */
    public LogicalCircuit getCircuit(int index) {

        return bypass[index];

    }

    /**
     * _HZbg܂B
     * @param index _H̔ԍ(1`7)
     * @param circuit _H(́Q)
     */
    public void setDoubleInputCircuit(int index, DoubleInputCircuit circuit) {

        sockets[index].setCircuit(circuit);

    }

    /**
     * _H\Pbg擾܂B
     * @param index _H̔ԍ(1`7)
     * @return _H(́Q)̃\Pbg
     */
    public DoubleInputSocket getDoubleInputCircuitSocket(int index) {

        return sockets[index];

    }

}