/*
 * Decompiled with CFR 0.152.
 */
package logicirc.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import logicirc.core.AndCircuit;
import logicirc.core.CircuitAdapter;
import logicirc.core.DoubleInputCircuit;
import logicirc.core.DoubleInputSocket;
import logicirc.core.LogicalCircuit;
import logicirc.core.OrCircuit;
import logicirc.core.SingleInputCircuit;
import logicirc.core.Voltage;
import logicirc.core.XorCircuit;
import logicirc.view.BoardStateEvent;
import logicirc.view.BoardStateListener;
import logicirc.view.CircuitBoard;

public final class LogicalCircuitSimulator
extends JFrame {
    public LogicalCircuitSimulator() {
        Object object;
        CircuitPanel[] circuitPanelArray;
        Object object2;
        CircuitBoard circuitBoard = new CircuitBoard();
        this.setTitle("\u8ad6\u7406\u56de\u8def\u30b7\u30df\u30e5\u30ec\u30fc\u30bf");
        ((Component)this).setSize(480, 320);
        ((Component)this).setLocation(100, 100);
        this.setResizable(false);
        this.setDefaultCloseOperation(3);
        this.getContentPane().setBackground(Color.white);
        this.getContentPane().setLayout(null);
        JPanel jPanel = new JPanel(null);
        this.getContentPane().add(jPanel);
        jPanel.setBounds(32, 8, 420, 320);
        jPanel.setOpaque(false);
        Rectangle rectangle = new Rectangle(16, 16, 24, 24);
        BitPanel[] bitPanelArray = new BitPanel[8];
        int n = 0;
        while (n < bitPanelArray.length) {
            object2 = circuitBoard.getAdapter(n / 2, n % 2);
            bitPanelArray[n] = new BitPanel(((CircuitAdapter)object2).getOutput());
            bitPanelArray[n].setBounds(rectangle);
            bitPanelArray[n].addMouseListener(new OnBitPanelClicked(circuitBoard, (SingleInputCircuit)object2));
            jPanel.add(bitPanelArray[n]);
            circuitBoard.addBoardStateListener(bitPanelArray[n]);
            rectangle.y += 32;
            ++n;
        }
        object2 = new BitPanel[7];
        int n2 = 0;
        while (n2 < ((BitPanel[])object2).length) {
            circuitPanelArray = circuitBoard.getCircuit(n2);
            object2[n2] = new BitPanel((LogicalCircuit)circuitPanelArray);
            jPanel.add((Component)object2[n2]);
            circuitBoard.addBoardStateListener((BoardStateListener)object2[n2]);
            switch (n2) {
                case 0: {
                    rectangle.x = 128;
                    rectangle.y = 32;
                    break;
                }
                case 1: {
                    rectangle.x = 128;
                    rectangle.y = 96;
                    break;
                }
                case 2: {
                    rectangle.x = 128;
                    rectangle.y = 160;
                    break;
                }
                case 3: {
                    rectangle.x = 128;
                    rectangle.y = 224;
                    break;
                }
                case 4: {
                    rectangle.x = 256;
                    rectangle.y = 64;
                    break;
                }
                case 5: {
                    rectangle.x = 256;
                    rectangle.y = 192;
                    break;
                }
                case 6: {
                    rectangle.x = 384;
                    rectangle.y = 128;
                }
            }
            ((Component)object2[n2]).setBounds(rectangle);
            ++n2;
        }
        rectangle.width = 64;
        rectangle.height = 64;
        circuitPanelArray = new CircuitPanel[7];
        int n3 = 0;
        while (n3 < circuitPanelArray.length) {
            switch (n3) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    object = new XorCircuit();
                    break;
                }
                case 4: 
                case 5: {
                    object = new AndCircuit();
                    break;
                }
                case 6: {
                    object = new OrCircuit();
                    break;
                }
                default: {
                    object = null;
                }
            }
            DoubleInputSocket doubleInputSocket = circuitBoard.getDoubleInputCircuitSocket(n3);
            doubleInputSocket.setCircuit((DoubleInputCircuit)object);
            circuitPanelArray[n3] = new CircuitPanel(doubleInputSocket);
            switch (n3) {
                case 0: {
                    rectangle.x = 52;
                    rectangle.y = 12;
                    break;
                }
                case 1: {
                    rectangle.x = 52;
                    rectangle.y = 76;
                    break;
                }
                case 2: {
                    rectangle.x = 52;
                    rectangle.y = 140;
                    break;
                }
                case 3: {
                    rectangle.x = 52;
                    rectangle.y = 204;
                    break;
                }
                case 4: {
                    rectangle.x = 174;
                    rectangle.y = 42;
                    break;
                }
                case 5: {
                    rectangle.x = 174;
                    rectangle.y = 172;
                    break;
                }
                case 6: {
                    rectangle.x = 300;
                    rectangle.y = 107;
                }
            }
            jPanel.add(circuitPanelArray[n3]);
            circuitPanelArray[n3].setBounds(rectangle);
            circuitPanelArray[n3].addMouseListener(new OnCircuitPanelClicked(circuitBoard, doubleInputSocket));
            circuitBoard.addBoardStateListener(circuitPanelArray[n3]);
            ++n3;
        }
        object = new JComponent(){

            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                graphics.drawLine(24, 21, 40, 21);
                graphics.drawLine(24, 51, 40, 51);
                graphics.drawLine(24, 85, 40, 85);
                graphics.drawLine(24, 115, 40, 115);
                graphics.drawLine(24, 149, 40, 149);
                graphics.drawLine(24, 179, 40, 179);
                graphics.drawLine(24, 213, 40, 213);
                graphics.drawLine(24, 243, 40, 243);
                graphics.drawLine(100, 36, 112, 36);
                graphics.drawLine(100, 100, 112, 100);
                graphics.drawLine(100, 164, 112, 164);
                graphics.drawLine(100, 228, 112, 228);
                graphics.drawLine(136, 36, 160, 53);
                graphics.drawLine(136, 100, 160, 78);
                graphics.drawLine(136, 163, 160, 184);
                graphics.drawLine(136, 228, 160, 209);
                graphics.drawLine(221, 66, 241, 66);
                graphics.drawLine(221, 196, 240, 196);
                graphics.drawLine(263, 68, 283, 116);
                graphics.drawLine(263, 197, 283, 146);
                graphics.drawLine(348, 131, 368, 131);
            }
        };
        jPanel.add((Component)object);
        ((Component)object).setBounds(16, 8, 400, 300);
        circuitBoard.fireChangeState();
    }

    public static void main(String[] stringArray) {
        LogicalCircuitSimulator logicalCircuitSimulator = new LogicalCircuitSimulator();
        logicalCircuitSimulator.show();
    }

    static class OnCircuitPanelClicked
    extends MouseAdapter {
        CircuitBoard board;
        DoubleInputSocket socket;

        OnCircuitPanelClicked(CircuitBoard circuitBoard, DoubleInputSocket doubleInputSocket) {
            this.board = circuitBoard;
            this.socket = doubleInputSocket;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            DoubleInputCircuit doubleInputCircuit = this.socket.getCircuit();
            if (doubleInputCircuit instanceof AndCircuit) {
                this.socket.setCircuit(new OrCircuit());
            } else if (doubleInputCircuit instanceof OrCircuit) {
                this.socket.setCircuit(new XorCircuit());
            } else if (doubleInputCircuit instanceof XorCircuit) {
                this.socket.setCircuit(new AndCircuit());
            }
            this.board.fireChangeState();
        }
    }

    static class OnBitPanelClicked
    extends MouseAdapter {
        CircuitBoard board;
        SingleInputCircuit circuit;

        OnBitPanelClicked(CircuitBoard circuitBoard, SingleInputCircuit singleInputCircuit) {
            this.board = circuitBoard;
            this.circuit = singleInputCircuit;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            BitPanel bitPanel = (BitPanel)mouseEvent.getSource();
            bitPanel.swapState();
            this.circuit.setInput(bitPanel.getState() ? Voltage.HIGH : Voltage.LOW);
            this.board.fireChangeState();
        }
    }

    static class CircuitPanel
    extends JComponent
    implements BoardStateListener {
        static ImageIcon GIF_AND;
        static ImageIcon GIF_OR;
        static ImageIcon GIF_XOR;
        DoubleInputSocket socket;

        CircuitPanel(DoubleInputSocket doubleInputSocket) {
            this.socket = doubleInputSocket;
            Class<?> clazz = this.getClass();
            GIF_AND = new ImageIcon(clazz.getResource("/logicirc/images/AND.gif"));
            GIF_OR = new ImageIcon(clazz.getResource("/logicirc/images/OR.gif"));
            GIF_XOR = new ImageIcon(clazz.getResource("/logicirc/images/XOR.gif"));
        }

        public void stateChanged(BoardStateEvent boardStateEvent) {
            this.repaint();
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            DoubleInputCircuit doubleInputCircuit = this.socket.getCircuit();
            Image image = doubleInputCircuit instanceof AndCircuit ? GIF_AND.getImage() : (doubleInputCircuit instanceof OrCircuit ? GIF_OR.getImage() : (doubleInputCircuit instanceof XorCircuit ? GIF_XOR.getImage() : GIF_AND.getImage()));
            graphics.drawImage(image, 0, 0, null);
        }
    }

    static class BitPanel
    extends JComponent
    implements BoardStateListener {
        static final Color LIGHT_YELLOW = new Color(255, 255, 127);
        Color color;
        LogicalCircuit circuit;
        boolean state;

        BitPanel(boolean bl) {
            this.state = bl;
            this.color = LIGHT_YELLOW;
        }

        BitPanel(LogicalCircuit logicalCircuit) {
            this.circuit = logicalCircuit;
            this.color = Color.white;
        }

        public void stateChanged(BoardStateEvent boardStateEvent) {
            if (this.circuit != null) {
                this.state = this.circuit.getOutput();
            }
            this.repaint();
        }

        void swapState() {
            this.state = !this.state;
            this.repaint();
        }

        boolean getState() {
            return this.state;
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            graphics.setColor(this.color);
            graphics.fillRect(0, 0, 23, 23);
            graphics.setColor(Color.black);
            graphics.drawRect(0, 0, 23, 23);
            graphics.drawString(this.state ? "1" : "0", 8, 16);
        }
    }
}

