/*
 * Decompiled with CFR 0.152.
 */
package logicirc.view;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import logicirc.core.CircuitAdapter;
import logicirc.core.DoubleInputCircuit;
import logicirc.core.DoubleInputSocket;
import logicirc.core.LogicalCircuit;
import logicirc.core.Voltage;
import logicirc.view.BoardStateEvent;
import logicirc.view.BoardStateListener;

public final class CircuitBoard {
    private DoubleInputSocket[] sockets;
    private CircuitAdapter[][] adapters;
    private CircuitAdapter lastAdapter;
    private CircuitAdapter[] bypass;
    private List listeners = new LinkedList();

    public CircuitBoard() {
        int n;
        this.adapters = new CircuitAdapter[7][];
        int n2 = 0;
        while (n2 < this.adapters.length) {
            this.adapters[n2] = new CircuitAdapter[2];
            n = 0;
            while (n < this.adapters[n2].length) {
                this.adapters[n2][n] = new CircuitAdapter();
                ++n;
            }
            ++n2;
        }
        this.lastAdapter = new CircuitAdapter();
        this.sockets = new DoubleInputSocket[7];
        this.sockets[0] = new DoubleInputSocket(this.adapters[0][0], this.adapters[0][1], this.adapters[4][0]);
        this.sockets[1] = new DoubleInputSocket(this.adapters[1][0], this.adapters[1][1], this.adapters[4][1]);
        this.sockets[2] = new DoubleInputSocket(this.adapters[2][0], this.adapters[2][1], this.adapters[5][0]);
        this.sockets[3] = new DoubleInputSocket(this.adapters[3][0], this.adapters[3][1], this.adapters[5][1]);
        this.sockets[4] = new DoubleInputSocket(this.adapters[4][0], this.adapters[4][1], this.adapters[6][0]);
        this.sockets[5] = new DoubleInputSocket(this.adapters[5][0], this.adapters[5][1], this.adapters[6][1]);
        this.sockets[6] = new DoubleInputSocket(this.adapters[6][0], this.adapters[6][1], this.lastAdapter);
        this.adapters[0][0].setInput(Voltage.LOW);
        this.adapters[0][1].setInput(Voltage.LOW);
        this.adapters[1][0].setInput(Voltage.LOW);
        this.adapters[1][1].setInput(Voltage.LOW);
        this.adapters[2][0].setInput(Voltage.LOW);
        this.adapters[2][1].setInput(Voltage.HIGH);
        this.adapters[3][0].setInput(Voltage.HIGH);
        this.adapters[3][1].setInput(Voltage.LOW);
        this.bypass = new CircuitAdapter[7];
        n = 0;
        while (n < this.bypass.length) {
            this.bypass[n] = new CircuitAdapter();
            ++n;
        }
        this.bypass[0].setInput(this.adapters[4][0]);
        this.bypass[1].setInput(this.adapters[4][1]);
        this.bypass[2].setInput(this.adapters[5][0]);
        this.bypass[3].setInput(this.adapters[5][1]);
        this.bypass[4].setInput(this.adapters[6][0]);
        this.bypass[5].setInput(this.adapters[6][1]);
        this.bypass[6].setInput(this.lastAdapter);
    }

    public void addBoardStateListener(BoardStateListener boardStateListener) {
        this.listeners.add(boardStateListener);
    }

    public void fireChangeState() {
        BoardStateEvent boardStateEvent = new BoardStateEvent(this);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            BoardStateListener boardStateListener = (BoardStateListener)iterator.next();
            if (boardStateListener == null) continue;
            boardStateListener.stateChanged(boardStateEvent);
        }
    }

    public boolean getOutput(int n) {
        return this.bypass[n].getOutput();
    }

    public CircuitAdapter getAdapter(int n, int n2) {
        return this.adapters[n][n2];
    }

    public LogicalCircuit getCircuit(int n) {
        return this.bypass[n];
    }

    public void setDoubleInputCircuit(int n, DoubleInputCircuit doubleInputCircuit) {
        this.sockets[n].setCircuit(doubleInputCircuit);
    }

    public DoubleInputSocket getDoubleInputCircuitSocket(int n) {
        return this.sockets[n];
    }
}

