package net.argius.lifegame;

import java.util.*;

/**
 * EB
 */
final class World {

    private int h;
    private int v;
    private boolean[] lives;
    private boolean[] children;
    private boolean loop;

    /**
     * RXgN^B
     * @param h TCY
     * @param v cTCY
     */
    World(int h, int v) {
        this.h = h;
        this.v = v;
        this.lives = new boolean[h * v];
        this.loop = true;
    }

    /**
     * ωB
     */
    synchronized void change() {
        if (children == null || children.length != lives.length) {
            children = lives.clone();
        }
        for (int i = 0; i < lives.length; i++) {
            int count = getNeighboringLivesCount(i);
            children[i] = (lives[i] && count == 2 || count == 3);
        }
        System.arraycopy(children, 0, lives, 0, lives.length);
    }

    /**
     * אڂ𐔂B
     * @param i Ƃ鐶̈ʒu
     * @return 
     */
    private int getNeighboringLivesCount(int i) {
        boolean loop = this.loop;
        final int x = i % h;
        final int y = i / h;
        final int u = (loop && y < 1) ? v - 1 : y - 1;
        final int d = (loop && y >= v - 1) ? 0 : y + 1;
        final int l = (loop && x < 1) ? h - 1 : x - 1;
        final int r = (loop && x >= h - 1) ? 0 : x + 1;
        List<Integer> a = new ArrayList<Integer>();
        a.add(u * h + l);
        a.add(u * h + x);
        a.add(u * h + r);
        a.add(y * h + l);
        a.add(y * h + r);
        a.add(d * h + l);
        a.add(d * h + x);
        a.add(d * h + r);
        int count = 0;
        for (Integer index : a) {
            if (0 <= index && index < lives.length && lives[index]) {
                ++count;
            }
        }
        return count;
    }

    /**
     * TCYύXB
     * @param h TCY
     * @param v cTCY
     */
    synchronized void resize(int h, int v) {
        boolean[] a = new boolean[h * v];
        int minh = Math.min(this.h, h);
        int minv = Math.min(this.v, v);
        for (int y = 0; y < minv; y++) {
            for (int x = 0; x < minh; x++) {
                a[h * y + x] = lives[this.h * y + x];
            }
        }
        this.h = h;
        this.v = v;
        this.lives = a;
    }

    /**
     * Ԃݒ肷B
     * @param src Ԍ
     * @param merge Ԃ}[Wꍇ<code>true</code>ݒ
     */
    synchronized void setState(World src, boolean merge) {
        if (merge) {
            final int length = Math.min(lives.length, src.lives.length);
            for (int i = 0; i < length; i++) {
                if (src.lives[i]) {
                    lives[i] = true;
                }
            }
        } else {
            this.h = src.h;
            this.v = src.v;
            this.lives = src.lives.clone();
        }
        this.loop = src.loop;
    }

    /**
     * wWɐ݂邩ǂ𒲂ׂB
     * @param x XW
     * @param y YW
     * @return wWɐ݂邩ǂ
     */
    synchronized boolean alive(int x, int y) {
        return lives[h * y + x];
    }

    /**
     * wWɐaB
     * @param x XW
     * @param y YW
     */
    synchronized void bear(int x, int y) {
        lives[h * y + x] = true;
    }

    /**
     * wW̐𖕏B
     * @param x XW
     * @param y YW
     */
    synchronized void erase(int x, int y) {
        lives[h * y + x] = false;
    }

    /**
     * TCY̎擾B
     * @return TCY
     */
    int getH() {
        return h;
    }

    /**
     * cTCY̎擾B
     * @return cTCY
     */
    int getV() {
        return v;
    }

    /**
     * ẺʂĂ[v邩ǂԂB
     * @return ẺʂĂ[v邩ǂ
     */
    boolean isLoop() {
        return loop;
    }

    /**
     * ẺʂĂ[v邩ǂݒ肷B
     * @param loop ẺʂĂ[v邩ǂ
     */
    void setLoop(boolean loop) {
        this.loop = loop;
    }

}
