package net.argius.lifegame;

import static javax.swing.JOptionPane.*;

import java.awt.*;
import java.awt.datatransfer.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import java.util.List;

import javax.swing.*;
import javax.swing.event.*;

import net.argius.lifegame.Menu.*;

/**
 * EBhE\B
 */
public final class WindowView extends JFrame {

    /**
     * <code>FONT</code>
     */
    static final Font FONT = new Font("sans-serif", Font.BOLD, 16);

    /**
     * <code>TITLE</code>
     */
    private static final String TITLE = Resource.getString(".TITLE");

    /**
     * <code>HEIGHT_ADJUSTMENT</code>
     */
    private static final int HEIGHT_ADJUSTMENT = 49;

    /**
     * <code>WIDTH_ADJUSTMENT</code>
     */
    private static final int WIDTH_ADJUSTMENT = 7;

    private static List<WindowView> views = new ArrayList<WindowView>();

    int rectSize;
    long lastMoved;
    Color foreColor;

    private final World world;
    private final Progress progress;

    private String currentDir;

    /**
     * RXgN^B
     */
    WindowView() {
        // j[̐ݒ
        Menu menubar = new Menu();
        setJMenuBar(menubar);
        menubar.addMenuListener(new MenuListener() {

            public void menuSelected(MenuEvent e) {
                final Object src = e.getSource();
                if (!(src instanceof Menu.Item)) {
                    return;
                }
                EventQueue.invokeLater(new Runnable() {

                    public void run() {
                        menu((Item)src);
                    }

                });
            }

            public void menuDeselected(MenuEvent e) {
                // ignore
            }

            public void menuCanceled(MenuEvent e) {
                // ignore
            }

        });

        // CX^X̐ݒ
        views.add(this);
        this.world = new World(Resource.DEFAULT_WORLD_SIZE.width, Resource.DEFAULT_WORLD_SIZE.height);
        this.progress = new Progress(world);
        this.currentDir = "";
        this.rectSize = 3;
        this.lastMoved = 0L;
        this.foreColor = Color.WHITE;

        // EBhE̐ݒ
        setTitle(TITLE);
        setBackground(Color.BLACK);
        setDefaultCloseOperation(DISPOSE_ON_CLOSE);
        setIconImage(Resource.getImage("icon.gif"));

        // isEE̐ݒ
        final Progress progress = this.progress;
        progress.setDaemon(true);
        progress.addWorldChangeListener(new WorldChangeListener() {

            public void worldChanged(World world) {
                repaint();
            }

        });

        // LoX̐ݒ
        final World world = this.world;
        add(new JPanel(true) {

            private Image image;

            {
                setOpaque(false);
                addMouseListener(new MouseAdapter() {

                    @Override
                    public void mousePressed(MouseEvent e) {
                        if (SwingUtilities.isLeftMouseButton(e)) {
                            Point p = e.getPoint();
                            int x = p.x / rectSize;
                            int y = p.y / rectSize;
                            if (world.alive(x, y)) {
                                world.erase(x, y);
                            } else {
                                world.bear(x, y);
                            }
                            repaint();
                        } else if (SwingUtilities.isRightMouseButton(e)) {
                            JPopupMenu pmenu = new JPopupMenu();
                            Menu menu = new Menu();
                            menu.addMenuListener(new MenuListener() {

                                public void menuSelected(MenuEvent e) {
                                    final Object src = e.getSource();
                                    if (!(src instanceof Menu.Item)) {
                                        return;
                                    }
                                    EventQueue.invokeLater(new Runnable() {

                                        public void run() {
                                            menu((Item)src);
                                        }

                                    });
                                }

                                public void menuDeselected(MenuEvent e) {
                                    // ignore
                                }

                                public void menuCanceled(MenuEvent e) {
                                    // ignore
                                }

                            });
                            for (Component component : menu.getComponents()) {
                                pmenu.add(component);
                            }
                            pmenu.show(WindowView.this, e.getX(), e.getY());
                        }
                    }

                });
            }

            /* @see javax.swing.JComponent#paintComponent(java.awt.Graphics) */
            @Override
            protected void paintComponent(Graphics g) {
                if (image == null
                    || getWidth() != image.getWidth(this)
                    || getHeight() != image.getHeight(this)) {
                    image = createImage(getWidth(), getHeight());
                    if (image == null) {
                        throw new IllegalStateException("image buffer not created");
                    }
                }
                draw(image.getGraphics());
                g.drawImage(image, 0, 0, null);
                Toolkit.getDefaultToolkit().sync();
            }

            /**
             * `悷B
             * @param g
             */
            private void draw(Graphics g) {
                g.clearRect(0, 0, getWidth(), getHeight());
                g.setFont(FONT);
                g.setColor(foreColor);
                final int h = world.getH();
                final int v = world.getV();
                for (int y = 0; y < v; y++) {
                    for (int x = 0; x < h; x++) {
                        if (world.alive(x, y)) {
                            g.fillRect(x * rectSize, y * rectSize, rectSize, rectSize);
                        }
                    }
                }
                drawMessage(g, "GENERATION " + progress.getGenerationCount(), 18, 30);
                if (System.currentTimeMillis() - lastMoved < 3000L) {
                    drawMessage(g, "INTERVAL = " + progress.getInterval(), 24, 48);
                }
            }

            private void drawMessage(Graphics g, String message, int x, int y) {
                g.setColor(Color.BLACK);
                g.drawString(message, x - 1, y - 1);
                g.drawString(message, x - 1, y + 1);
                g.drawString(message, x + 1, y - 1);
                g.drawString(message, x + 1, y + 1);
                g.setColor(Color.WHITE);
                g.drawString(message, x, y);
            }

        });

        // TCY̏
        addComponentListener(new ComponentAdapter() {

            @Override
            public void componentResized(ComponentEvent e) {
                int h = (getWidth() - WIDTH_ADJUSTMENT) / rectSize;
                int v = (getHeight() - HEIGHT_ADJUSTMENT) / rectSize;
                world.resize(h, v);
                int width = h * rectSize + WIDTH_ADJUSTMENT;
                int height = v * rectSize + HEIGHT_ADJUSTMENT;
                if (width != getWidth() || height != getHeight()) {
                    setSize(width, height);
                    repaint();
                }
            }

        });

        // }EXzC[̏
        getContentPane().addMouseWheelListener(new MouseWheelListener() {

            public void mouseWheelMoved(MouseWheelEvent e) {
                processMouseWheelEvent(e);
            }

        });

        // Q[Jn
        setBlockSize(world.getH(), world.getV());
        progress.start();
    }

    /* @see javax.swing.JFrame#processWindowEvent(java.awt.event.WindowEvent) */
    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == WindowEvent.WINDOW_CLOSING) {
            confirmExit();
        }
    }

    /* @see java.awt.Component#processMouseWheelEvent(java.awt.event.MouseWheelEvent) */
    @Override
    protected void processMouseWheelEvent(MouseWheelEvent e) {
        int wheelRotation = e.getWheelRotation();
        long interval = progress.getInterval();
        interval += wheelRotation * 10;
        progress.setInterval(interval);
        lastMoved = System.currentTimeMillis();
        repaint();
    }

    /**
     * ԂωƂʒmB
     */
    private void stateChanged() {
        setBlockSize(world.getH(), world.getV());
    }

    /**
     * ubNTCY̐ݒB
     * @param columns 
     * @param rows s
     */
    private void setBlockSize(int columns, int rows) {
        final int width = columns * rectSize + WIDTH_ADJUSTMENT;
        final int height = rows * rectSize + HEIGHT_ADJUSTMENT;
        setSize(width, height);
        repaint();
    }

    /**
     * j[̏B
     * @param item j[
     */
    void menu(Item item) {
        try {
            switch (item) {
                case OPEN:
                    openFile();
                    break;
                case EXIT:
                    confirmExit();
                    break;
                case PASTE:
                    paste();
                    break;
                case FORECOLOR: {
                    Color chosen = JColorChooser.showDialog(this,
                                                            getString("dialogtitle.forecolor"),
                                                            foreColor);
                    if (chosen != null) {
                        foreColor = chosen;
                        stateChanged();
                    }
                }
                    break;
                case BACKCOLOR: {
                    Color chosen = JColorChooser.showDialog(this,
                                                            getString("dialogtitle.backcolor"),
                                                            getBackground());
                    if (chosen != null) {
                        setBackground(chosen);
                    }
                }
                    break;
                case SIZE_PER_LIFE: {
                    SpinnerNumberModel model = new SpinnerNumberModel(rectSize, 2, 16, 1);
                    showMessageDialog(this,
                                      new JSpinner(model),
                                      getString("dialogtitle.sizeperlife"),
                                      INFORMATION_MESSAGE);
                    rectSize = model.getNumber().intValue();
                    stateChanged();
                }
                    break;
                case START_OR_PAUSE:
                    if (progress.isRunning()) {
                        progress.pause();
                    } else {
                        progress.restart();
                    }
                    break;
                case ADD_RANDOM: {
                    World w = WorldFactory.create(null, 0.02f, world.getH(), world.getV());
                    world.setState(w, true);
                    stateChanged();
                }
                    break;
                case ONLINEHELP:
                    showHelp();
                    break;
                case ABOUT:
                    String s = Resource.getString(".ABOUT",
                                                  Resource.getString(".TITLE"),
                                                  Resource.getString(".VERSION",
                                                                     Resource.getVersionString()));
                    showMessageDialog(this, s, "", 0, new ImageIcon(getIconImage()));
                    break;
                default:
            }
        } catch (Exception ex) {
            showMessageDialog(this, ex);
        }
    }

    /**
     * ImFvB
     */
    void confirmExit() {
        String message = Resource.getString("WindowView.confirmquit");
        if (showConfirmDialog(WindowView.this, message, "", YES_NO_OPTION) == OK_OPTION) {
            for (WindowView view : views) {
                view.dispose();
            }
            views.clear();
        }
    }

    /**
     * wv̕\B
     */
    private void showHelp() {
        String cmd = "cmd.exe /K \"start http://www.google.co.jp/search?q=lifegame\"";
        try {
            Runtime.getRuntime().exec(cmd);
        } catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    /**
     * t@CJB
     * @throws IOException o̓G[ꍇ
     */
    private void openFile() throws IOException {
        JFileChooser dialog = new JFileChooser(currentDir);
        dialog.setFileSelectionMode(JFileChooser.FILES_ONLY);
        dialog.showDialog(this, null);
        File file = dialog.getSelectedFile();
        if (file != null) {
            world.setState(WorldFactory.create(file), false);
            stateChanged();
            currentDir = file.getParent();
        }
    }

    /**
     * \tB
     * @throws UnsupportedFlavorException
     * @throws IOException o̓G[ꍇ
     */
    private void paste() throws UnsupportedFlavorException, IOException {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable t = clipboard.getContents(null);
        String s = (String)t.getTransferData(DataFlavor.stringFlavor);
        World lines = WorldFactory.create(s.split("\n"));
        final int height = lines.getH();
        final int width = lines.getV();
        for (int y = 0; y < width; y++) {
            for (int x = 0; x < height; x++) {
                if (lines.alive(x, y)) {
                    world.bear(x, y);
                } else {
                    world.erase(x, y);
                }
            }
        }
        repaint();
    }

    /**
     * ̎擾B
     * @param key L[(Zk)
     * @param args p[^
     * @return 
     */
    private static String getString(String key, Object... args) {
        return Resource.getString("WindowView." + key, args);
    }

    /**
     * NB
     * @param args gpȂ
     */
    public static void main(String... args) {
        EventQueue.invokeLater(new Runnable() {

            public void run() {
                MonospacedFontLookAndFeel.install();
                JFrame f = new WindowView();
                f.setLocationRelativeTo(null);
                f.setVisible(true);
            }

        });
    }

}
