package net.argius.lifegame;

import java.awt.*;
import java.io.*;
import java.text.*;
import java.util.*;

/**
 * \[XB
 */
final class Resource {

    static final Dimension DEFAULT_WORLD_SIZE = new Dimension(120, 80);

    private static final String BUNDLE_NAME = "net.argius.lifegame.messages";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(BUNDLE_NAME);

    /**
     * O̎擾B
     * @param key L[
     * @param args p[^
     * @return 
     */
    static String getString(String key, Object... args) {
        try {
            String s = RESOURCE_BUNDLE.getString(key);
            if (args.length == 0) {
                return s;
            } else {
                return MessageFormat.format(s, args);
            }
        } catch (MissingResourceException e) {
            return '!' + key + '!';
        }
    }

    /**
     * 摜̎擾B
     * @param name 摜̃\[X
     * @return 摜
     */
    static Image getImage(String name) {
        return Toolkit.getDefaultToolkit().createImage(Resource.class.getResource(name));
    }

    /**
     * o[W̎擾B
     * @return o[W
     */
    static String getVersionString() {
        InputStream is = Resource.class.getResourceAsStream("version");
        try {
            Scanner scanner = new Scanner(is);
            return scanner.nextLine();
        } finally {
            try {
                is.close();
            } catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

}
