package net.argius.lifegame;

import java.awt.*;
import java.util.Map.*;

import javax.swing.*;
import javax.swing.UIDefaults.*;
import javax.swing.plaf.*;
import javax.swing.plaf.basic.*;

/**
 * tHgɂLaFB
 */
final class MonospacedFontLookAndFeel extends BasicLookAndFeel {

    private LookAndFeel base;

    /**
     * RXgN^B
     * @param base bƂȂLaF
     */
    MonospacedFontLookAndFeel(LookAndFeel base) {
        this.base = base;
    }

    /**
     * LaFCXg[B
     */
    static void install() {
        LookAndFeel laf = new MonospacedFontLookAndFeel(UIManager.getLookAndFeel());
        try {
            UIManager.setLookAndFeel(laf);
        } catch (UnsupportedLookAndFeelException ex) {
            throw new IllegalStateException(ex.toString());
        }
    }

    /* @see javax.swing.plaf.basic.BasicLookAndFeel#getDefaults() */
    @Override
    public UIDefaults getDefaults() {
        UIDefaults defaults = base.getDefaults();
        for (Entry<Object, Object> entry : defaults.entrySet()) {
            Object key = entry.getKey();
            if (String.valueOf(key).endsWith("font")) {
                Object value = entry.getValue();
                if (value instanceof UIDefaults.ActiveValue) {
                    ActiveValue activeValue = (ActiveValue)value;
                    entry.setValue(new FontChangingActiveValue(activeValue));
                }
            }
        }
        return defaults;
    }

    /* @see javax.swing.LookAndFeel#getDescription() */
    @Override
    public String getDescription() {
        return base.getDescription();
    }

    /* @see javax.swing.LookAndFeel#getID() */
    @Override
    public String getID() {
        return base.getID();
    }

    /* @see javax.swing.LookAndFeel#getName() */
    @Override
    public String getName() {
        return base.getName();
    }

    /* @see javax.swing.LookAndFeel#isNativeLookAndFeel() */
    @Override
    public boolean isNativeLookAndFeel() {
        return false;
    }

    /* @see javax.swing.LookAndFeel#isSupportedLookAndFeel() */
    @Override
    public boolean isSupportedLookAndFeel() {
        return base.isSupportedLookAndFeel();
    }

    /**
     * tHgύXActiveValueB
     */
    private static final class FontChangingActiveValue implements ActiveValue {

        private ActiveValue base;

        /**
         * RXgN^B
         * @param base
         */
        FontChangingActiveValue(ActiveValue base) {
            this.base = base;
        }

        /* @see javax.swing.UIDefaults.ActiveValue#createValue(javax.swing.UIDefaults) */
        public Object createValue(UIDefaults table) {
            Object o = base.createValue(table);
            if (o instanceof FontUIResource) {
                FontUIResource r = (FontUIResource)o;
                String family = "Monospaced";
                int style = Font.PLAIN;
                return new FontUIResource(family, style, r.getSize());
            } else {
                return o;
            }
        }

    }

}
