package net.argius.lifegame;

import java.io.*;
import java.util.*;

/**
 * R\[\B
 */
public final class ConsoleView {

    static final String LIFE = Resource.getString("ConsoleView.LIFE");
    static final String SPACE = Resource.getString("ConsoleView.SPACE");

    /**
     * RXgN^B
     */
    private ConsoleView() {
        // empty
    }

    /**
     * o[W\B
     */
    static void showVersionInfo() {
        String s = Resource.getString(".ABOUT",
                                      Resource.getString(".TITLE"),
                                      Resource.getString(".VERSION",
                                                         Resource.getVersionString()));
        System.out.println(s);
    }

    /**
     * NB
     * @param args s
     */
    public static void main(String... args) {
        String arg0 = args.length > 0 ? args[0] : "";
        if (arg0.equals("-v") || arg0.equals("--version")) {
            showVersionInfo();
            return;
        }
        final World world;
        if (arg0.length() > 0) {
            // t@C琶
            try {
                world = WorldFactory.create(new File(arg0));
            } catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        } else {
            // _
            world = WorldFactory.create(new Random(System.currentTimeMillis()), 0.38f, 40, 20);
        }
        final int width = world.getH();
        final int height = world.getV();
        final Progress progress = new Progress(world);
        progress.setDaemon(true);
        progress.setInterval(100L);
        progress.addWorldChangeListener(new WorldChangeListener() {

            public void worldChanged(World world) {
                Writer buffer = new StringWriter();
                PrintWriter out = new PrintWriter(buffer);
                boolean end = true;
                for (int y = 0; y < height; y++) {
                    for (int x = 0; x < width; x++) {
                        final String piece;
                        if (world.alive(x, y)) {
                            piece = LIFE;
                            end = false;
                        } else {
                            piece = SPACE;
                        }
                        out.print(piece);
                    }
                    out.println();
                }
                out.flush();
                System.out.println(buffer);
                if (end) {
                    System.out.println("end: ");
                    System.exit(0);
                }
            }

        });
        progress.start();
        progress.restart();
        Scanner scanner = new Scanner(System.in);
        scanner.nextLine();
    }

}
