/*
 * Decompiled with CFR 0.152.
 */
package net.argius.lifegame;

import java.util.ArrayList;

final class World {
    private int h;
    private int v;
    private boolean[] lives;
    private boolean[] children;
    private boolean loop;

    World(int n, int n2) {
        this.h = n;
        this.v = n2;
        this.lives = new boolean[n * n2];
        this.loop = true;
    }

    synchronized void change() {
        if (this.children == null || this.children.length != this.lives.length) {
            this.children = (boolean[])this.lives.clone();
        }
        for (int i = 0; i < this.lives.length; ++i) {
            int n = this.getNeighboringLivesCount(i);
            this.children[i] = this.lives[i] && n == 2 || n == 3;
        }
        System.arraycopy(this.children, 0, this.lives, 0, this.lives.length);
    }

    private int getNeighboringLivesCount(int n) {
        boolean bl = this.loop;
        int n2 = n % this.h;
        int n3 = n / this.h;
        int n4 = bl && n3 < 1 ? this.v - 1 : n3 - 1;
        int n5 = bl && n3 >= this.v - 1 ? 0 : n3 + 1;
        int n6 = bl && n2 < 1 ? this.h - 1 : n2 - 1;
        int n7 = bl && n2 >= this.h - 1 ? 0 : n2 + 1;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(n4 * this.h + n6);
        arrayList.add(n4 * this.h + n2);
        arrayList.add(n4 * this.h + n7);
        arrayList.add(n3 * this.h + n6);
        arrayList.add(n3 * this.h + n7);
        arrayList.add(n5 * this.h + n6);
        arrayList.add(n5 * this.h + n2);
        arrayList.add(n5 * this.h + n7);
        int n8 = 0;
        for (Integer n9 : arrayList) {
            if (0 > n9 || n9 >= this.lives.length || !this.lives[n9]) continue;
            ++n8;
        }
        return n8;
    }

    synchronized void resize(int n, int n2) {
        boolean[] blArray = new boolean[n * n2];
        int n3 = Math.min(this.h, n);
        int n4 = Math.min(this.v, n2);
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                blArray[n * i + j] = this.lives[this.h * i + j];
            }
        }
        this.h = n;
        this.v = n2;
        this.lives = blArray;
    }

    synchronized void setState(World world, boolean bl) {
        if (bl) {
            int n = Math.min(this.lives.length, world.lives.length);
            for (int i = 0; i < n; ++i) {
                if (!world.lives[i]) continue;
                this.lives[i] = true;
            }
        } else {
            this.h = world.h;
            this.v = world.v;
            this.lives = (boolean[])world.lives.clone();
        }
        this.loop = world.loop;
    }

    synchronized boolean alive(int n, int n2) {
        return this.lives[this.h * n2 + n];
    }

    synchronized void bear(int n, int n2) {
        this.lives[this.h * n2 + n] = true;
    }

    synchronized void erase(int n, int n2) {
        this.lives[this.h * n2 + n] = false;
    }

    int getH() {
        return this.h;
    }

    int getV() {
        return this.v;
    }

    boolean isLoop() {
        return this.loop;
    }

    void setLoop(boolean bl) {
        this.loop = bl;
    }
}

