package net.argius.lifegame;

import java.util.*;

/**
 * isB
 */
final class Progress extends Thread {

    private final World world;

    private List<WorldChangeListener> listeners;
    private long interval;
    private boolean running;
    private long generationCount;

    /**
     * RXgN^B
     * @param world World
     */
    Progress(World world) {
        this.world = world;
        this.interval = 100L;
        this.running = false;
        this.listeners = new ArrayList<WorldChangeListener>();
        this.generationCount = 0L;
    }

    /* @see java.lang.Thread#run() */
    @Override
    public void run() {
        while (true) {
            synchronized (this) {
                if (!running) {
                    try {
                        wait();
                    } catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            world.change();
            ++generationCount;
            fireWorldChanged();
            try {
                Thread.sleep(interval);
            } catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * WorldChangeListener̓o^B
     * @param listener WorldChangeListener
     */
    void addWorldChangeListener(WorldChangeListener listener) {
        listeners.add(listener);
    }

    /**
     * ԂύXꂽƂʒmB
     */
    private void fireWorldChanged() {
        for (WorldChangeListener listener : listeners) {
            listener.worldChanged(world);
        }
    }

    /**
     * isĊJB
     */
    synchronized void restart() {
        running = true;
        fireWorldChanged();
        notify();
    }

    /**
     * isꎞ~B
     */
    synchronized void pause() {
        running = false;
        fireWorldChanged();
    }

    /**
     * Ԋu̎擾B
     * @return Ԋu
     */
    long getInterval() {
        return interval;
    }

    /**
     * Ԋu̐ݒB
     * @param interval Ԋu
     */
    void setInterval(long interval) {
        if (interval < 10L || 1000L < interval) {
            return;
        }
        this.interval = interval;
    }

    /**
     * isǂԂB
     * @return isȂ<code>true</code>AłȂ<code>false</code>
     */
    boolean isRunning() {
        return running;
    }

    /**
     * JEg̎擾B
     * @return JEg
     */
    long getGenerationCount() {
        return generationCount;
    }

}
