package net.argius.lifegame;

import static java.awt.event.KeyEvent.*;
import static net.argius.lifegame.Resource.getString;

import java.awt.event.*;
import java.util.*;

import javax.swing.*;
import javax.swing.event.*;

/**
 * j[B
 */
final class Menu extends JMenuBar {

    /**
     * j[ځB
     */
    enum Item {

        /**
         * <code>NEW</code>
         */
        NEW("file.new"),

        /**
         * <code>OPEN</code>
         */
        OPEN("file.open"),

        /**
         * <code>CLOSE</code>
         */
        CLOSE("file.close"),

        /**
         * <code>EXIT</code>
         */
        EXIT("file.exit"),

        /**
         * <code>PASTE</code>
         */
        PASTE("edit.paste"),

        /**
         * <code>FORECOLOR</code>
         */
        FORECOLOR("view.forecolor"),

        /**
         * <code>BACKCOLOR</code>
         */
        BACKCOLOR("view.backcolor"),

        /**
         * <code>SIZE_PER_LIFE</code>
         */
        SIZE_PER_LIFE("view.sizeperlife"),

        /**
         * <code>START_OR_PAUSE</code>
         */
        START_OR_PAUSE("game.startorpause"),

        /**
         * <code>ADD_RANDOM</code>
         */
        ADD_RANDOM("game.addrandom"),

        /**
         * <code>HELP</code>
         */
        HELP("help.help"),

        /**
         * <code>ONLINEHELP</code>
         */
        ONLINEHELP("help.onlinehelp"),

        /**
         * <code>ABOUT</code>
         */
        ABOUT("help.about");

        private String string;

        /**
         * RXgN^B
         * @param string ږ
         */
        private Item(String string) {
            this.string = string;
        }

        /**
         * ږ̎擾B
         * @return ږ
         */
        String getString() {
            return string;
        }

    }

    private List<MenuListener> listeners;

    /**
     * RXgN^B
     */
    Menu() {
        this.listeners = new ArrayList<MenuListener>();
        add(createJMenu("file",
                        'F',
                        createJMenuItem(Item.OPEN, 'O', getKeyStroke(VK_O, true)),
                        new JSeparator(),
                        createJMenuItem(Item.EXIT, 'X', getKeyStroke(VK_Q, true))));
        add(createJMenu("edit",
                        'E', createJMenuItem(Item.PASTE, 'P', getKeyStroke(VK_V, true))));
        add(createJMenu("view",
                        'V',
                        createJMenuItem(Item.FORECOLOR, 'F', getKeyStroke(VK_F, false)),
                        createJMenuItem(Item.BACKCOLOR, 'B', getKeyStroke(VK_B, false)),
                        createJMenuItem(Item.SIZE_PER_LIFE, 'S', getKeyStroke(VK_S, false))
                        ));
        add(createJMenu("game",
                        'G',
                        createJMenuItem(Item.START_OR_PAUSE, 'S', getKeyStroke(VK_ENTER, false)),
                        new JSeparator(),
                        createJMenuItem(Item.ADD_RANDOM, 'R', getKeyStroke(VK_R, false))
                        ));
        add(createJMenu("help",
                        'H',
                        createJMenuItem(Item.ONLINEHELP, 'H'),
                        new JSeparator(),
                        createJMenuItem(Item.ABOUT, 'A')));
    }

    /**
     * MenuListener̓o^B
     * @param listener MenuListener
     */
    void addMenuListener(MenuListener listener) {
        listeners.add(listener);
    }

    /**
     * MenuListener̉B
     * @param listener MenuListener
     */
    void removeMenuListener(MenuListener listener) {
        listeners.remove(listener);
    }

    /**
     * j[IꂽƂʒmB
     * @param item j[
     */
    void fireMenuSelected(Item item) {
        MenuEvent event = new MenuEvent(item);
        for (MenuListener listener : listeners) {
            listener.menuSelected(event);
        }
    }

    /**
     * JMenu̐B
     * @param key \̃L[
     * @param mnemonic 蓖ĕ
     * @param components R|[lg̔z
     * @return JMenu    
     */
    private static JMenu createJMenu(String key, char mnemonic, JComponent... components) {
        JMenu menu = new JMenu(getMessage(key));
        menu.setMnemonic(mnemonic);
        for (JComponent component : components) {
            menu.add(component);
        }
        return menu;
    }

    /**
     * JMenuItem̐B
     * @param key j[L[
     * @param mnemonic 蓖ĕ
     * @return JMenuItem
     */
    private JMenuItem createJMenuItem(Item key, char mnemonic) {
        JMenuItem o = new JMenuItem(getMessage(key.getString()), mnemonic);
        o.setName(key.name());
        final Item actionKey = key;
        o.addActionListener(new AbstractAction() {

            public void actionPerformed(ActionEvent e) {
                fireMenuSelected(actionKey);
            }

        });
        return o;
    }

    /**
     * JMenuItem̐B
     * @param key j[L[
     * @param mnemonic 蓖ĕ
     * @param shortcut V[gJbgL[
     * @return JMenuItem
     */
    private JMenuItem createJMenuItem(Item key, char mnemonic, KeyStroke shortcut) {
        JMenuItem o = createJMenuItem(key, mnemonic);
        o.setAccelerator(shortcut);
        return o;
    }

    /**
     * KeyStroke̎擾B
     * @param key L[
     * @param withControlKey Rg[L[gpꍇ <code>true</code>
     * @return KeyStroke
     */
    private static KeyStroke getKeyStroke(int key, boolean withControlKey) {
        return KeyStroke.getKeyStroke(key, (withControlKey ? InputEvent.CTRL_MASK : 0));
    }

    /**
     * bZ[W̎擾B
     * @param key bZ[WL[
     * @return bZ[W
     */
    private static String getMessage(String key) {
        return getString("Menu." + key);
    }

}
