/*
 * Decompiled with CFR 0.152.
 */
package net.argius.lifegame;

import java.util.ArrayList;
import java.util.List;
import net.argius.lifegame.World;
import net.argius.lifegame.WorldChangeListener;

final class Progress
extends Thread {
    private final World world;
    private List<WorldChangeListener> listeners;
    private long interval;
    private boolean running;
    private long generationCount;

    Progress(World world) {
        this.world = world;
        this.interval = 100L;
        this.running = false;
        this.listeners = new ArrayList<WorldChangeListener>();
        this.generationCount = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            Progress progress = this;
            synchronized (progress) {
                if (!this.running) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
            this.world.change();
            ++this.generationCount;
            this.fireWorldChanged();
            try {
                Thread.sleep(this.interval);
                continue;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                continue;
            }
            break;
        }
    }

    void addWorldChangeListener(WorldChangeListener worldChangeListener) {
        this.listeners.add(worldChangeListener);
    }

    private void fireWorldChanged() {
        for (WorldChangeListener worldChangeListener : this.listeners) {
            worldChangeListener.worldChanged(this.world);
        }
    }

    synchronized void restart() {
        this.running = true;
        this.fireWorldChanged();
        this.notify();
    }

    synchronized void pause() {
        this.running = false;
        this.fireWorldChanged();
    }

    long getInterval() {
        return this.interval;
    }

    void setInterval(long l) {
        if (l < 10L || 1000L < l) {
            return;
        }
        this.interval = l;
    }

    boolean isRunning() {
        return this.running;
    }

    long getGenerationCount() {
        return this.generationCount;
    }
}

