/*
 * Decompiled with CFR 0.152.
 */
package net.argius.lifegame;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import net.argius.lifegame.Resource;

final class Menu
extends JMenuBar {
    private List<MenuListener> listeners = new ArrayList<MenuListener>();

    Menu() {
        this.add(Menu.createJMenu("file", 'F', this.createJMenuItem(Item.OPEN, 'O', Menu.getKeyStroke(79, true)), new JSeparator(), this.createJMenuItem(Item.EXIT, 'X', Menu.getKeyStroke(81, true))));
        this.add(Menu.createJMenu("edit", 'E', this.createJMenuItem(Item.PASTE, 'P', Menu.getKeyStroke(86, true))));
        this.add(Menu.createJMenu("view", 'V', this.createJMenuItem(Item.FORECOLOR, 'F', Menu.getKeyStroke(70, false)), this.createJMenuItem(Item.BACKCOLOR, 'B', Menu.getKeyStroke(66, false)), this.createJMenuItem(Item.SIZE_PER_LIFE, 'S', Menu.getKeyStroke(83, false))));
        this.add(Menu.createJMenu("game", 'G', this.createJMenuItem(Item.START_OR_PAUSE, 'S', Menu.getKeyStroke(10, false)), new JSeparator(), this.createJMenuItem(Item.ADD_RANDOM, 'R', Menu.getKeyStroke(82, false))));
        this.add(Menu.createJMenu("help", 'H', this.createJMenuItem(Item.ONLINEHELP, 'H'), new JSeparator(), this.createJMenuItem(Item.ABOUT, 'A')));
    }

    void addMenuListener(MenuListener menuListener) {
        this.listeners.add(menuListener);
    }

    void removeMenuListener(MenuListener menuListener) {
        this.listeners.remove(menuListener);
    }

    void fireMenuSelected(Item item) {
        MenuEvent menuEvent = new MenuEvent((Object)item);
        for (MenuListener menuListener : this.listeners) {
            menuListener.menuSelected(menuEvent);
        }
    }

    private static JMenu createJMenu(String string, char c, JComponent ... jComponentArray) {
        JMenu jMenu = new JMenu(Menu.getMessage(string));
        jMenu.setMnemonic(c);
        for (JComponent jComponent : jComponentArray) {
            jMenu.add(jComponent);
        }
        return jMenu;
    }

    private JMenuItem createJMenuItem(Item item, char c) {
        JMenuItem jMenuItem = new JMenuItem(Menu.getMessage(item.getString()), c);
        jMenuItem.setName(item.name());
        final Item item2 = item;
        jMenuItem.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Menu.this.fireMenuSelected(item2);
            }
        });
        return jMenuItem;
    }

    private JMenuItem createJMenuItem(Item item, char c, KeyStroke keyStroke) {
        JMenuItem jMenuItem = this.createJMenuItem(item, c);
        jMenuItem.setAccelerator(keyStroke);
        return jMenuItem;
    }

    private static KeyStroke getKeyStroke(int n, boolean bl) {
        return KeyStroke.getKeyStroke(n, bl ? 2 : 0);
    }

    private static String getMessage(String string) {
        return Resource.getString("Menu." + string, new Object[0]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Item {
        NEW("file.new"),
        OPEN("file.open"),
        CLOSE("file.close"),
        EXIT("file.exit"),
        PASTE("edit.paste"),
        FORECOLOR("view.forecolor"),
        BACKCOLOR("view.backcolor"),
        SIZE_PER_LIFE("view.sizeperlife"),
        START_OR_PAUSE("game.startorpause"),
        ADD_RANDOM("game.addrandom"),
        HELP("help.help"),
        ONLINEHELP("help.onlinehelp"),
        ABOUT("help.about");

        private String string;

        private Item(String string2) {
            this.string = string2;
        }

        String getString() {
            return this.string;
        }
    }
}

