/*
 * Decompiled with CFR 0.152.
 */
package net.argius.lifegame;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Random;
import java.util.Scanner;
import net.argius.lifegame.Progress;
import net.argius.lifegame.Resource;
import net.argius.lifegame.World;
import net.argius.lifegame.WorldChangeListener;
import net.argius.lifegame.WorldFactory;

public final class ConsoleView {
    static final String LIFE = Resource.getString("ConsoleView.LIFE", new Object[0]);
    static final String SPACE = Resource.getString("ConsoleView.SPACE", new Object[0]);

    private ConsoleView() {
    }

    static void showVersionInfo() {
        String string = Resource.getString(".ABOUT", Resource.getString(".TITLE", new Object[0]), Resource.getString(".VERSION", Resource.getVersionString()));
        System.out.println(string);
    }

    public static void main(String ... stringArray) {
        World world;
        String string;
        String string2 = string = stringArray.length > 0 ? stringArray[0] : "";
        if (string.equals("-v") || string.equals("--version")) {
            ConsoleView.showVersionInfo();
            return;
        }
        if (string.length() > 0) {
            try {
                world = WorldFactory.create(new File(string));
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        } else {
            world = WorldFactory.create(new Random(System.currentTimeMillis()), 0.38f, 40, 20);
        }
        final int n = world.getH();
        final int n2 = world.getV();
        Progress progress = new Progress(world);
        progress.setDaemon(true);
        progress.setInterval(100L);
        progress.addWorldChangeListener(new WorldChangeListener(){

            public void worldChanged(World world) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                boolean bl = true;
                for (int i = 0; i < n2; ++i) {
                    for (int j = 0; j < n; ++j) {
                        String string;
                        if (world.alive(j, i)) {
                            string = LIFE;
                            bl = false;
                        } else {
                            string = SPACE;
                        }
                        printWriter.print(string);
                    }
                    printWriter.println();
                }
                printWriter.flush();
                System.out.println(stringWriter);
                if (bl) {
                    System.out.println("end: ");
                    System.exit(0);
                }
            }
        });
        progress.start();
        progress.restart();
        Scanner scanner = new Scanner(System.in);
        scanner.nextLine();
    }
}

