package net.argius.lifegame;

import java.io.*;
import java.util.*;

/**
 * Ẽt@NgB
 */
final class WorldFactory {

    /**
     * World̐B
     * @param file f[^t@C
     * @return World
     * @throws IOException 
     */
    static World create(File file) throws IOException {
        Scanner scanner = new Scanner(file);
        try {
            List<String> a = new ArrayList<String>();
            while (scanner.hasNextLine()) {
                a.add(scanner.nextLine());
            }
            return create(a.toArray(new String[a.size()]));
        } finally {
            scanner.close();
        }
    }

    /**
     * World̐B
     * @param lines f[^
     * @return World
     */
    static World create(String[] lines) {
        int width = 0;
        for (String line : lines) {
            width = Math.max(width, line.length());
        }
        World world = new World(width, lines.length);
        String blankCharPattern = "[" + Resource.getString("WorldFactory.BlankChars") + "]";
        int y = 0;
        for (String line : lines) {
            int x = 0;
            for (char c : line.replaceAll(blankCharPattern, " ").toCharArray()) {
                if (c != ' ') {
                    world.bear(x, y);
                }
                ++x;
            }
            ++y;
        }
        return world;
    }

    /**
     * World̐B
     * @param random _(null̏ꍇ͎ݒ)
     * @param rate (0.0rate1.0)
     * @param width 
     * @param height 
     * @return World
     */
    static World create(Random random, float rate, int width, int height) {
        Random r = (random == null) ? new Random(System.currentTimeMillis()) : random;
        World world = new World(width, height);
        for (int y = 0; y < height; y++) {
            for (int x = 0; x < width; x++) {
                if (r.nextFloat() < rate) {
                    world.bear(x, y);
                }
            }
        }
        return world;
    }

}
