/*
 * Decompiled with CFR 0.152.
 */
package net.argius.lifegame;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import net.argius.lifegame.Menu;
import net.argius.lifegame.MonospacedFontLookAndFeel;
import net.argius.lifegame.Progress;
import net.argius.lifegame.Resource;
import net.argius.lifegame.World;
import net.argius.lifegame.WorldChangeListener;
import net.argius.lifegame.WorldFactory;

public final class WindowView
extends JFrame {
    static final Font FONT = new Font("sans-serif", 1, 16);
    private static final String TITLE = Resource.getString(".TITLE", new Object[0]);
    private static final int HEIGHT_ADJUSTMENT = 49;
    private static final int WIDTH_ADJUSTMENT = 7;
    private static List<WindowView> views = new ArrayList<WindowView>();
    int rectSize;
    long lastMoved;
    Color foreColor;
    private final World world;
    private final Progress progress;
    private String currentDir;

    WindowView() {
        Menu menu = new Menu();
        this.setJMenuBar(menu);
        menu.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent menuEvent) {
                final Object object = menuEvent.getSource();
                if (!(object instanceof Menu.Item)) {
                    return;
                }
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        WindowView.this.menu((Menu.Item)((Object)object));
                    }
                });
            }

            public void menuDeselected(MenuEvent menuEvent) {
            }

            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
        views.add(this);
        this.world = new World(Resource.DEFAULT_WORLD_SIZE.width, Resource.DEFAULT_WORLD_SIZE.height);
        this.progress = new Progress(this.world);
        this.currentDir = "";
        this.rectSize = 3;
        this.lastMoved = 0L;
        this.foreColor = Color.WHITE;
        this.setTitle(TITLE);
        this.setBackground(Color.BLACK);
        this.setDefaultCloseOperation(2);
        this.setIconImage(Resource.getImage("icon.gif"));
        final Progress progress = this.progress;
        progress.setDaemon(true);
        progress.addWorldChangeListener(new WorldChangeListener(){

            public void worldChanged(World world) {
                WindowView.this.repaint();
            }
        });
        final World world = this.world;
        this.add(new JPanel(true){
            private Image image;
            {
                super(bl);
                this.setOpaque(false);
                this.addMouseListener(new MouseAdapter(){

                    public void mousePressed(MouseEvent mouseEvent) {
                        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                            Point point = mouseEvent.getPoint();
                            int n = point.x / WindowView.this.rectSize;
                            int n2 = point.y / WindowView.this.rectSize;
                            if (world.alive(n, n2)) {
                                world.erase(n, n2);
                            } else {
                                world.bear(n, n2);
                            }
                            this.repaint();
                        } else if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                            JPopupMenu jPopupMenu = new JPopupMenu();
                            Menu menu = new Menu();
                            menu.addMenuListener(new MenuListener(){

                                public void menuSelected(MenuEvent menuEvent) {
                                    final Object object = menuEvent.getSource();
                                    if (!(object instanceof Menu.Item)) {
                                        return;
                                    }
                                    EventQueue.invokeLater(new Runnable(){

                                        public void run() {
                                            WindowView.this.menu((Menu.Item)((Object)object));
                                        }
                                    });
                                }

                                public void menuDeselected(MenuEvent menuEvent) {
                                }

                                public void menuCanceled(MenuEvent menuEvent) {
                                }
                            });
                            for (Component component : menu.getComponents()) {
                                jPopupMenu.add(component);
                            }
                            jPopupMenu.show(WindowView.this, mouseEvent.getX(), mouseEvent.getY());
                        }
                    }
                });
            }

            protected void paintComponent(Graphics graphics) {
                if (this.image == null || this.getWidth() != this.image.getWidth(this) || this.getHeight() != this.image.getHeight(this)) {
                    this.image = this.createImage(this.getWidth(), this.getHeight());
                    if (this.image == null) {
                        throw new IllegalStateException("image buffer not created");
                    }
                }
                this.draw(this.image.getGraphics());
                graphics.drawImage(this.image, 0, 0, null);
                Toolkit.getDefaultToolkit().sync();
            }

            private void draw(Graphics graphics) {
                graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
                graphics.setFont(FONT);
                graphics.setColor(WindowView.this.foreColor);
                int n = world.getH();
                int n2 = world.getV();
                for (int i = 0; i < n2; ++i) {
                    for (int j = 0; j < n; ++j) {
                        if (!world.alive(j, i)) continue;
                        graphics.fillRect(j * WindowView.this.rectSize, i * WindowView.this.rectSize, WindowView.this.rectSize, WindowView.this.rectSize);
                    }
                }
                this.drawMessage(graphics, "GENERATION " + progress.getGenerationCount(), 18, 30);
                if (System.currentTimeMillis() - WindowView.this.lastMoved < 3000L) {
                    this.drawMessage(graphics, "INTERVAL = " + progress.getInterval(), 24, 48);
                }
            }

            private void drawMessage(Graphics graphics, String string, int n, int n2) {
                graphics.setColor(Color.BLACK);
                graphics.drawString(string, n - 1, n2 - 1);
                graphics.drawString(string, n - 1, n2 + 1);
                graphics.drawString(string, n + 1, n2 - 1);
                graphics.drawString(string, n + 1, n2 + 1);
                graphics.setColor(Color.WHITE);
                graphics.drawString(string, n, n2);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                int n = (WindowView.this.getWidth() - 7) / WindowView.this.rectSize;
                int n2 = (WindowView.this.getHeight() - 49) / WindowView.this.rectSize;
                world.resize(n, n2);
                int n3 = n * WindowView.this.rectSize + 7;
                int n4 = n2 * WindowView.this.rectSize + 49;
                if (n3 != WindowView.this.getWidth() || n4 != WindowView.this.getHeight()) {
                    WindowView.this.setSize(n3, n4);
                    WindowView.this.repaint();
                }
            }
        });
        this.getContentPane().addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                WindowView.this.processMouseWheelEvent(mouseWheelEvent);
            }
        });
        this.setBlockSize(world.getH(), world.getV());
        progress.start();
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.confirmExit();
        }
    }

    protected void processMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
        int n = mouseWheelEvent.getWheelRotation();
        long l = this.progress.getInterval();
        this.progress.setInterval(l += (long)(n * 10));
        this.lastMoved = System.currentTimeMillis();
        this.repaint();
    }

    private void stateChanged() {
        this.setBlockSize(this.world.getH(), this.world.getV());
    }

    private void setBlockSize(int n, int n2) {
        int n3 = n * this.rectSize + 7;
        int n4 = n2 * this.rectSize + 49;
        this.setSize(n3, n4);
        this.repaint();
    }

    void menu(Menu.Item item) {
        try {
            switch (item) {
                case OPEN: {
                    this.openFile();
                    break;
                }
                case EXIT: {
                    this.confirmExit();
                    break;
                }
                case PASTE: {
                    this.paste();
                    break;
                }
                case FORECOLOR: {
                    Color color = JColorChooser.showDialog(this, WindowView.getString("dialogtitle.forecolor", new Object[0]), this.foreColor);
                    if (color != null) {
                        this.foreColor = color;
                        this.stateChanged();
                    }
                    break;
                }
                case BACKCOLOR: {
                    Color color = JColorChooser.showDialog(this, WindowView.getString("dialogtitle.backcolor", new Object[0]), this.getBackground());
                    if (color != null) {
                        this.setBackground(color);
                    }
                    break;
                }
                case SIZE_PER_LIFE: {
                    SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(this.rectSize, 2, 16, 1);
                    JOptionPane.showMessageDialog(this, new JSpinner(spinnerNumberModel), WindowView.getString("dialogtitle.sizeperlife", new Object[0]), 1);
                    this.rectSize = spinnerNumberModel.getNumber().intValue();
                    this.stateChanged();
                    break;
                }
                case START_OR_PAUSE: {
                    if (this.progress.isRunning()) {
                        this.progress.pause();
                        break;
                    }
                    this.progress.restart();
                    break;
                }
                case ADD_RANDOM: {
                    World world = WorldFactory.create(null, 0.02f, this.world.getH(), this.world.getV());
                    this.world.setState(world, true);
                    this.stateChanged();
                    break;
                }
                case ONLINEHELP: {
                    this.showHelp();
                    break;
                }
                case ABOUT: {
                    String string = Resource.getString(".ABOUT", Resource.getString(".TITLE", new Object[0]), Resource.getString(".VERSION", Resource.getVersionString()));
                    JOptionPane.showMessageDialog(this, string, "", 0, new ImageIcon(this.getIconImage()));
                    break;
                }
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception);
        }
    }

    void confirmExit() {
        String string = Resource.getString("WindowView.confirmquit", new Object[0]);
        if (JOptionPane.showConfirmDialog(this, string, "", 0) == 0) {
            for (WindowView windowView : views) {
                windowView.dispose();
            }
            views.clear();
        }
    }

    private void showHelp() {
        String string = "cmd.exe /K \"start http://www.google.co.jp/search?q=lifegame\"";
        try {
            Runtime.getRuntime().exec(string);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private void openFile() throws IOException {
        JFileChooser jFileChooser = new JFileChooser(this.currentDir);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.showDialog(this, null);
        File file = jFileChooser.getSelectedFile();
        if (file != null) {
            this.world.setState(WorldFactory.create(file), false);
            this.stateChanged();
            this.currentDir = file.getParent();
        }
    }

    private void paste() throws UnsupportedFlavorException, IOException {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(null);
        String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
        World world = WorldFactory.create(string.split("\n"));
        int n = world.getH();
        int n2 = world.getV();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                if (world.alive(j, i)) {
                    this.world.bear(j, i);
                    continue;
                }
                this.world.erase(j, i);
            }
        }
        this.repaint();
    }

    private static String getString(String string, Object ... objectArray) {
        return Resource.getString("WindowView." + string, objectArray);
    }

    public static void main(String ... stringArray) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                MonospacedFontLookAndFeel.install();
                WindowView windowView = new WindowView();
                windowView.setLocationRelativeTo(null);
                windowView.setVisible(true);
            }
        });
    }
}

