package lifegame.view;

import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

/**
 * TCY̐ݒύX邽߂̃_CAOłB
 */
public class SizeConfigurationDialog extends JDialog {

    private static final Font defaultFont = new Font("Monospaced", Font.PLAIN, 12);
    private static final String[] ERROR_MSG = new String[]{
            "͓eɃG[܂@ȉmFĂ",
            "EẼTCÝA郉Ct̃TCYA" +
               Configuration.SIZE_X_MIN + "`" +
               Configuration.SIZE_X_MAX + "͈̔",
            "EẼTCYćAc郉Ct̃TCYA" +
               Configuration.SIZE_Y_MIN + "`" +
               Configuration.SIZE_Y_MAX + "͈̔",
            "ECt̃TCÝA" + 
               Configuration.SIZE_DOT_MIN + "`" +
               Configuration.SIZE_DOT_MAX + "͈̔",
            "EE" +
               (Configuration.SIZE_DOT_MIN - 1) + "`" +
               (Configuration.SIZE_DOT_MAX - 1) +
               "͈̔ (Ct̃TCY傫ł܂)"};
    
    private static final KeyStroke ESCAPE_KEY = KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0);
    
    private Configuration configuration;
    
    private JTextField verticalSize;
    private JTextField horizontalSize;
    private JTextField blockSize;
    private JTextField borderSize;
    
    /**
     * ConfigDialog𐶐܂B
     * @param owner et[
     * @param configuration ݒ
     */
    public SizeConfigurationDialog(JFrame owner, Configuration configuration) {

        super(owner);
        
        this.configuration = configuration;
        
        /*
         * _CAÔ̐ݒ
         */
        
        setSize(160, 240);
        setTitle("TCYύX");
        setResizable(false);
        setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        addKeyListener(new KeyListener() {
            
            /**
             * L[͂܂B
             * @param e L[Cxg
             */
            private void onKey(KeyEvent e) {
                if (e.getKeyCode() == KeyEvent.VK_ESCAPE) {
                    dispose();
                }
            }
            
            /* ( Javadoc)
             * @see java.awt.event.KeyListener#keyTyped(java.awt.event.KeyEvent)
             */
            public void keyTyped(KeyEvent e) {
                onKey(e);
            }
            
            /* ( Javadoc)
             * @see java.awt.event.KeyListener#keyPressed(java.awt.event.KeyEvent)
             */
            public void keyPressed(KeyEvent e) {

                onKey(e);
                
            }

            /* ( Javadoc)
             * @see java.awt.event.KeyListener#keyReleased(java.awt.event.KeyEvent)
             */
            public void keyReleased(KeyEvent e) {

            }
            
        });

        /*
         * CAEg
         */

        // x
        JLabel labelA1 = createLabel("ẼTCY");
        JLabel labelA2 = createLabel("");
        JLabel labelA3 = createLabel("c");
        JLabel labelB1 = createLabel("Ct̃TCY");
        JLabel labelB2 = createLabel("傫");
        JLabel labelB3 = createLabel("E");
        
        // eLXg
        horizontalSize = new JTextField(String.valueOf(configuration.worldSizeX), 4);
        verticalSize = new JTextField(String.valueOf(configuration.worldSizeY), 4);
        blockSize = new JTextField(String.valueOf(configuration.dotSize), 4);
        borderSize = new JTextField(String.valueOf(configuration.border), 4);
        FocusListener onTextFocused = new FocusAdapter() {
            public void focusGained(FocusEvent e) {
                Object o = e.getSource();
                if (o instanceof JTextField) {
                    JTextField text = (JTextField)e.getSource();
                    text.selectAll();
                }
            }
        };
        horizontalSize.addFocusListener(onTextFocused);
        verticalSize.addFocusListener(onTextFocused);
        blockSize.addFocusListener(onTextFocused);
        borderSize.addFocusListener(onTextFocused);
        
        // {^
        JButton submit = new JButton("m");
        submit.addActionListener(new AbstractAction() {
            Configuration c = SizeConfigurationDialog.this.configuration;
            public void actionPerformed(ActionEvent e) {
                c.worldSizeX = parseInteger(horizontalSize.getText());
                c.worldSizeY = parseInteger(verticalSize.getText());
                c.dotSize = parseInteger(blockSize.getText());
                c.border = parseInteger(borderSize.getText());
                if (c.isValid()) {
                    c.setEnable(true);
                    dispose();
                } else {
                    JOptionPane.showConfirmDialog(SizeConfigurationDialog.this,
                                                  ERROR_MSG,
                                                  "̓G[",
                                                  JOptionPane.CLOSED_OPTION);
                }
            }
        });

        /*
         * CAEg
         */
        JPanel panel = new JPanel(null);
        panel.add(labelA1);
        panel.add(labelA2);
        panel.add(labelA3);
        panel.add(verticalSize);
        panel.add(horizontalSize);
        panel.add(labelB1);
        panel.add(labelB2);
        panel.add(labelB3);
        panel.add(blockSize);
        panel.add(borderSize);
        panel.add(submit);

        final int heightCONST = 20;
        final int LEFT_POSITION1 = 8;
        final int LEFT_POSITION2 = 24;
        final int LEFT_POSITION3 = 64;
        final int TEXT_WIDTH = 48;
        
        int x = 0;
        int y = 16;
        
        // "ẼTCY"
        labelA1.setBounds(LEFT_POSITION1, y, 100, heightCONST);
        // ""
        y += heightCONST;
        labelA2.setBounds(LEFT_POSITION2, y, TEXT_WIDTH, heightCONST);
        horizontalSize.setBounds(LEFT_POSITION3, y, TEXT_WIDTH, heightCONST);
        // "c"
        y += heightCONST;
        labelA3.setBounds(LEFT_POSITION2, y, TEXT_WIDTH, heightCONST);
        verticalSize.setBounds(LEFT_POSITION3, y, TEXT_WIDTH, heightCONST);
        // "Ct̃TCY"
        y += heightCONST;
        y += heightCONST;
        labelB1.setBounds(LEFT_POSITION1, y, 100, heightCONST);
        // "傫"
        y += heightCONST;
        labelB2.setBounds(LEFT_POSITION2, y, TEXT_WIDTH, heightCONST);
        blockSize.setBounds(LEFT_POSITION3, y, TEXT_WIDTH, heightCONST);
        // "E"
        y += heightCONST;
        labelB3.setBounds(LEFT_POSITION2, y, TEXT_WIDTH, heightCONST);
        borderSize.setBounds(LEFT_POSITION3, y, TEXT_WIDTH, heightCONST);
        // "m{^"
        y += heightCONST;
        y += heightCONST;
        submit.setBounds(LEFT_POSITION2 + 4, y, 100, heightCONST);

        getContentPane().add(panel, BorderLayout.CENTER);
        
        horizontalSize.requestFocus();

    }
    
    /**
     * x𐶐܂B
     * @param caption x
     * @return x
     */
    private JLabel createLabel(String caption) {

        JLabel label = new JLabel(caption);
        label.setFont(defaultFont);
        return label;

    }
    
    /**
     * 𐮐ɕϊ܂B
     * @param value 
     * @return  ϊłȂ̏ꍇ<code>-1</code>
     */
    private int parseInteger(String value) {
        
        try {
            return Integer.parseInt(value);
        } catch (NumberFormatException ex) {
            return -1;
        }
        
    }

}
