package lifegame.view;

import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/**
 * Ԃ̌oߑxݒ肷_CAOłB
 */
public class IntervalTimeDialog extends JDialog {

    private static final String TITLE = "oߑx";
    private static final Font defaultFont = new Font("Monospaced", Font.PLAIN, 12);

    private static final int MAXIMUM = 1000;
    private static final int MINIMUM = 0;

    private JTextField intervalMilliSeconds;
    private JSlider slider;
    private Configuration configuration;

    /**
     * IntervalTimeDialog𐶐܂B
     * @param owner et[
     * @param configuration ݒ
     */
    public IntervalTimeDialog(JFrame owner, Configuration configuration) {

        super(owner);

        this.configuration = configuration;
        int value = (int)configuration.interval;

        /*
         * _CAÔ̐ݒ
         */

        setSize(200, 100);
        setTitle(TITLE);
        setResizable(false);
        setDefaultCloseOperation(DISPOSE_ON_CLOSE);
        addKeyListener(new KeyListener() {
            
            /**
             * L[͂܂B
             * @param e L[Cxg
             */
            private void onKey(KeyEvent e) {
                if (e.getKeyCode() == KeyEvent.VK_ESCAPE) {
                    dispose();
                }
            }
            
            /* ( Javadoc)
             * @see java.awt.event.KeyListener#keyTyped(java.awt.event.KeyEvent)
             */
            public void keyTyped(KeyEvent e) {
                onKey(e);
            }
            
            /* ( Javadoc)
             * @see java.awt.event.KeyListener#keyPressed(java.awt.event.KeyEvent)
             */
            public void keyPressed(KeyEvent e) {

                onKey(e);
                
            }

            /* ( Javadoc)
             * @see java.awt.event.KeyListener#keyReleased(java.awt.event.KeyEvent)
             */
            public void keyReleased(KeyEvent e) {

            }
            
        });

        /*
         * CAEg
         */

        // x
        JLabel label1 = new JLabel("~b^P");
        label1.setFont(defaultFont);

        // eLXg
        intervalMilliSeconds = new JTextField(String.valueOf(value), 4);
        intervalMilliSeconds.addFocusListener(new FocusAdapter() {

            JTextField t = intervalMilliSeconds;
            JSlider s = slider;
            Configuration conf = new Configuration();

            /* ( Javadoc)
             * @see java.awt.event.FocusListener#focusLost(java.awt.event.FocusEvent)
             */
            public void focusLost(FocusEvent e) {

                try {
                    conf.interval = Long.parseLong(intervalMilliSeconds
                            .getText());
                    if (conf.isValid()) {
                        slider.setValue((int)conf.interval);
                        IntervalTimeDialog.this.configuration.interval = conf.interval;
                    }
                } catch (NumberFormatException ex) {
                    ex.printStackTrace(System.err);
                }

            }

        });

        // XC_
        slider = new JSlider(MINIMUM, MAXIMUM, value);
        slider.setPaintTicks(true);
        slider.setMajorTickSpacing(500);
        slider.setMinorTickSpacing(50);
        slider.addChangeListener(new ChangeListener() {

            JTextField text = intervalMilliSeconds;
            Configuration conf = new Configuration();

            /* ( Javadoc)
             * @see javax.swing.event.ChangeListener#stateChanged(javax.swing.event.ChangeEvent)
             */
            public void stateChanged(ChangeEvent e) {

                JSlider s = (JSlider)e.getSource();
                conf.interval = s.getValue();
                text.setText(String.valueOf(conf.interval));
                if (conf.isValid()) {
                    IntervalTimeDialog.this.configuration.interval = conf.interval;
                }

            }

        });

        /*
         * CAEg
         */
        JPanel panel = new JPanel(null);
        panel.add(label1);
        panel.add(slider);
        panel.add(intervalMilliSeconds);

        intervalMilliSeconds.setBounds(32, 8, 40, 20);
        label1.setBounds(76, 8, 100, 20);
        slider.setBounds(8, 32, 176, 40);

        getContentPane().add(panel, BorderLayout.CENTER);

    }

}