package lifegame.view;

import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.filechooser.FileFilter;

import lifegame.core.Generation;
import lifegame.core.Progress;
import lifegame.core.Size;

/**
 * fthŃCtQ[łB
 */
public class GraphicalView extends JFrame {
    
    private static final String TITLE = "LifeGame";
    private static final String FILE_SUFFIX = ".lif";
    private static final Font menuFont = new Font("Monospaced", Font.PLAIN, 12);

    private static final KeyStroke SPACE_KEY = KeyStroke.getKeyStroke(KeyEvent.VK_SPACE, 0);
    private static final KeyStroke CTRL_K_KEY = KeyStroke.getKeyStroke(KeyEvent.VK_K, Event.CTRL_MASK);
    private static final KeyStroke CTRL_M_KEY = KeyStroke.getKeyStroke(KeyEvent.VK_M, Event.CTRL_MASK);
    private static final KeyStroke CTRL_O_KEY = KeyStroke.getKeyStroke(KeyEvent.VK_O, Event.CTRL_MASK);
    private static final KeyStroke CTRL_P_KEY = KeyStroke.getKeyStroke(KeyEvent.VK_P, Event.CTRL_MASK);
    private static final KeyStroke CTRL_R_KEY = KeyStroke.getKeyStroke(KeyEvent.VK_R, Event.CTRL_MASK);
    private static final KeyStroke CTRL_S_KEY = KeyStroke.getKeyStroke(KeyEvent.VK_S, Event.CTRL_MASK);
    
    private Configuration configuration;
    private File currentDirectory;
    
    private JMenuBar menuBar;
    private JPanel topPanel;
    private MouseListeningPanel panel;
    
    /**
     * JFileChoosergpt@CtB^łB
     */
    private FileFilter fileFilter = new FileFilter() {

        /* ( Javadoc)
         * @see javax.swing.filechooser.FileFilter#accept(java.io.File)
         */
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase().endsWith(FILE_SUFFIX);
        }

        /* ( Javadoc)
         * @see javax.swing.filechooser.FileFilter#getDescription()
         */
        public String getDescription() {
            return "CtQ[ f[^ (*.lif)";
        }

    };
    
    /**
     * GraphicalView𐶐܂B
     */
    public GraphicalView() {

        configuration = new Configuration();
        currentDirectory = new File(System.getProperty("user.dir"));

        topPanel = new JPanel(null);
        getContentPane().add(topPanel);
        
        // j[ : t@C
        JMenu menuFile = new JMenu("t@C(F)");
        menuFile.setMnemonic('F');
        menuFile.add(createJMenuItem("t@CJ(O)", 'O', CTRL_O_KEY, new AbstractAction() {
            public void actionPerformed(ActionEvent e) {
                // t@CI_CAO
                JFileChooser fileChooser = new JFileChooser(currentDirectory);
                fileChooser.setDialogTitle("t@CJ");
                fileChooser.setApproveButtonText("J");
                fileChooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
                fileChooser.setFileFilter(fileFilter);
                fileChooser.showDialog(GraphicalView.this, null);
                File file = fileChooser.getSelectedFile();
                if (file == null) {
                    return;
                }
                currentDirectory = file.getParentFile();
                // t@C畜
                try {
                    BufferedReader breader = new BufferedReader(new FileReader(file));
                    try {
                        StringBuffer buffer = new StringBuffer();
                        for (String s; (s = breader.readLine()) != null;) {
                            buffer.append(s);
                        }
                        Generation g = new Generation(buffer.toString());
                        Size gSize = g.getSize();
                        if (!panel.generation.getSize().equals(gSize)) {
                            // f[^̃TCYƌ݂̐ݒ̐`FbN
                            Configuration c = new Configuration(configuration);
                            c.worldSizeX = gSize.getWidth();
                            c.worldSizeY = gSize.getHeight();
                            if (c.isValid()) {
                                configuration.worldSizeX = gSize.getWidth();
                                configuration.worldSizeY = gSize.getHeight();
                                initialize();
                            } else {
                                JOptionPane.showConfirmDialog(GraphicalView.this,
                                                              "݂̃TCYݒł͂̃t@CJ܂",
                                                              "G[",
                                                              JOptionPane.CLOSED_OPTION);
                                return;
                            }
                        }
                        panel.generation = g;
                        panel.repaint();
                    } finally {
                        breader.close();
                    }
                } catch (Exception ex) {
                    JOptionPane.showConfirmDialog(GraphicalView.this,
                            new String[]{ex.getMessage() + " ̂",
                                         "t@CJ܂ł"},
                            "G[",
                            JOptionPane.CLOSED_OPTION);
                }
            }
        }));
        menuFile.add(createJMenuItem("t@Cɕۑ(S)", 'S', CTRL_S_KEY, new AbstractAction() {
            public void actionPerformed(ActionEvent e) {
                // t@CI_CAO
                JFileChooser fileChooser = new JFileChooser(currentDirectory);
                fileChooser.setDialogTitle("t@Cɕۑ");
                fileChooser.setApproveButtonText("ۑ");
                fileChooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
                fileChooser.setFileFilter(fileFilter);
                fileChooser.showDialog(GraphicalView.this, null);
                File file = fileChooser.getSelectedFile();
                if (file == null) {
                    return;
                }
                currentDirectory = file.getParentFile();
                // t@C֕ۑ
                try {
                    if (!file.getName().toLowerCase().endsWith(FILE_SUFFIX)) {
                        file = new File(file.getParent(), file.getName() + FILE_SUFFIX);
                    }
                    if (file.exists()) {
                        int r = JOptionPane.showConfirmDialog(
                                        GraphicalView.this,
                                        new String[]{"t@C͊ɑ݂܂",
                                                      "㏑Ă낵łH"},
                                        "t@C̏㏑",
                                        JOptionPane.YES_NO_OPTION);
                        if (r != JOptionPane.YES_OPTION) {
                            return;
                        }
                    }
                    PrintWriter pw = new PrintWriter(new FileWriter(file));
                    try {
                        pw.print(panel.generation);
                    } finally {
                        pw.close();
                    }
                } catch (FileNotFoundException ex) {
                    ex.printStackTrace();
                } catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }));
        menuFile.add(new JSeparator());
        menuFile.add(createJMenuItem("I(X)", 'X', null, new AbstractAction() {
            public void actionPerformed(ActionEvent e) {
                dispose();
                System.exit(0);
            }
        }));
        
        // j[ : Q[
        JMenu menuGame = new JMenu("Q[(G)");
        menuFile.setMnemonic('G');
        menuGame.add(createJMenuItem("X^[g/Xgbv(S)", 'S', SPACE_KEY, new AbstractAction() {
            public void actionPerformed(ActionEvent e) {
                panel.setRunning(!panel.isRunning());
                Thread t = new Thread(panel);
                t.start();
                setTitle(TITLE + (panel.isRunning() ? " (live) " : ""));
            }
        }));
        menuGame.add(new JSeparator());
        menuGame.add(createJMenuItem("Vbt(R)", 'R', CTRL_K_KEY, new AbstractAction() {
            public void actionPerformed(ActionEvent e) {
                Progress prog = new Progress(panel.generation);
                prog.shuffle(0.087);
                panel.repaint();
            }
        }));
        menuGame.add(createJMenuItem("(I)", 'I', CTRL_P_KEY, new AbstractAction() {
            public void actionPerformed(ActionEvent e) {
                Progress prog = new Progress(panel.generation);
                prog.increase(0.01);
                panel.repaint();
            }
        }));
        menuGame.add(createJMenuItem("(D)", 'D', CTRL_M_KEY, new AbstractAction() {
            public void actionPerformed(ActionEvent e) {
                Progress prog = new Progress(panel.generation);
                prog.decrease(0.01);
                panel.repaint();
            }
        }));
        menuGame.add(createJMenuItem("NA(C)", 'C', null, new AbstractAction() {
            public void actionPerformed(ActionEvent e) {
                panel.generation.clear();
                panel.repaint();
            }
        }));
        
        // j[ : ݒ
        JMenu menuConfiguration = new JMenu("ݒ(C)");
        menuConfiguration.setMnemonic('C');
        menuConfiguration.add(createJMenuItem("Ct̐FύX(L)", 'L', null, new AbstractAction() {
            public void actionPerformed(ActionEvent e) {
                Color c = JColorChooser.showDialog(null, "Ct̐F", configuration.foreColor);
                if (c != null) {
                    configuration.foreColor = c;
                    panel.repaint();
                }
            }
        }));
        menuConfiguration.add(createJMenuItem("wiFύX(B)", 'B', null, new AbstractAction() {
            public void actionPerformed(ActionEvent e) {
                Color c = JColorChooser.showDialog(null, "wiF", configuration.foreColor);
                if (c != null) {
                    configuration.backGroundColor = c;
                    panel.setBackground(c);
                    panel.repaint();
                }
            }
        }));
        menuConfiguration.add(createJMenuItem("oߑxύX(T)", 'T', null, new AbstractAction() {
            
            public void actionPerformed(ActionEvent e) {
                JFrame owner = GraphicalView.this;
                JDialog dialog = new IntervalTimeDialog(owner, configuration);
                dialog.setLocation(owner.getX() + 160, getY() + 40);
                dialog.setModal(true);
                dialog.show();
                
            }
            
        }));
        menuConfiguration.add(new JSeparator());
        menuConfiguration.add(createJMenuItem("TCYύX(R)", 'R', CTRL_R_KEY, new AbstractAction() {
            public void actionPerformed(ActionEvent e) {
                int r = JOptionPane.showConfirmDialog(GraphicalView.this, new String[]{
                        "݂̓eNA܂", "낵łH"}, "TCYύX",
                        JOptionPane.YES_NO_OPTION);
                if (r == JOptionPane.YES_OPTION) {
                    Configuration c = new Configuration(configuration);
                    JFrame owner = GraphicalView.this;
                    JDialog dialog = new SizeConfigurationDialog(owner, c);
                    dialog.setLocation(owner.getX() + 100, getY());
                    dialog.setModal(true);
                    dialog.show();
                    if (c.isEnable() && c.isValid()) {
                        configuration = c;
                        initialize();
                    }
                }
            }
        }));
        
        // j[ : wv
        JMenu menuHelp = new JMenu("wv(H)");
        menuHelp.setMnemonic('H');
        menuHelp.add(createJMenuItem("LifeGame ɂ(A)", 'A', null, new AbstractAction() {
            public void actionPerformed(ActionEvent e) {
                // _CAO\
                String[] s = new String[]{TITLE, "version 1.0"};
                JOptionPane pane = new JOptionPane(s, JOptionPane.INFORMATION_MESSAGE, JOptionPane.DEFAULT_OPTION);
                pane.setIcon(new ImageIcon(getIconImage()));
                JDialog dialog = pane.createDialog(GraphicalView.this, TITLE);
                dialog.show();
            }
        }));
        
        // j[o[
        menuBar = new JMenuBar();
        menuBar.add(menuFile);
        menuBar.add(menuGame);
        menuBar.add(menuConfiguration);
        menuBar.add(menuHelp);
        setJMenuBar(menuBar);
        adjustAllMenuElement(menuBar);

        // t[̂̐ݒ
        setTitle(TITLE);
        setResizable(false);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        Image icon = getImage();
        if (icon != null) {
            setIconImage(icon);
        }
        
        // ̏ڍ
        initialize();
        
    }
    
    /**
     * ڍׂȏ܂B 
     */
    private void initialize() {

        // t[TCY̒
        setSize(configuration.worldSizeX * configuration.dotSize + 9,
                configuration.worldSizeY * configuration.dotSize + 50);
        
        // CtẼpl
        boolean isRunning = false;
        if (panel != null) {
            isRunning = panel.isRunning();
            // ~
            panel.setRunning(false);
            topPanel.remove(panel);
            // ċN
            panel = new MouseListeningPanel(configuration);
            panel.setRunning(isRunning);
            Thread t = new Thread(panel);
            t.start();
            setTitle(TITLE + (panel.isRunning() ? " (live) " : ""));
        } else {
            panel = new MouseListeningPanel(configuration);
        }
        topPanel.add(panel);
        panel.setBounds(1, 
                	    0, 
                        configuration.worldSizeX * configuration.dotSize,
                        configuration.worldSizeY * configuration.dotSize);
        
        validate();
        
    }

    /**
     * ACRp̃C[W擾܂B
     * @return ACRC[W
     */
    private Image getImage() {
        
        try {
            String resourcePath = "/lifegame/view/icon.gif";
            URL url = getClass().getResource(resourcePath);
            return Toolkit.getDefaultToolkit().getImage(url);
        } catch (RuntimeException ex) {
            return null;
        }
        
    }
    
    /**
     * JMenuItem𐶐܂B
     * @param caption j[
     * @param mnemonic j[jbN
     * @param shortcutKey V[gJbgL[
     * @param action ANV
     * @return JMenuItem
     */
    private JMenuItem createJMenuItem(String caption,
            						   char mnemonic,
                                       KeyStroke shortcutKey,
                                       Action action) {
        
        JMenuItem item = new JMenuItem(caption, mnemonic);
        if (shortcutKey != null) {
            item.setAccelerator(shortcutKey);
        }
        if (action != null) {
            item.addActionListener(action);
        }
        return item;
        
    }
    
    /**
     * j[̑Svfɋʂ鏈s܂B
     * @param element j[̍ŏʃR|[lg
     */
    private void adjustAllMenuElement(MenuElement element) {

        MenuElement[] elements = element.getSubElements();
        for (int i = 0, n = elements.length; i < n; i++) {
            MenuElement subelement = elements[i];
            subelement.getComponent().setFont(menuFont);
            adjustAllMenuElement(subelement);
        }

    }
    
    /**
     * AvP[VN܂B
     * @param args 
     */
    public static void main(String[] args) {

        JFrame frame = new GraphicalView();
        frame.setLocation(200, 100);
        frame.show();

    }

}
