package lifegame.view;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;

import lifegame.core.Generation;
import lifegame.core.Progress;
import lifegame.core.Size;

/**
 * R\[ŃCtQ[łB
 */
public final class ConsoleView {

    /**
     * ݂̐\܂B
     * @param g 
     */
    private static void print(Generation g) {

        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);

        for (int i = 0; i < 100; i++) {
            pw.println();
        }
        Size size = g.getSize();
        for (int y = 0; y < size.getHeight(); y++) {
            for (int x = 0; x < size.getWidth(); x++) {
                pw.print((g.alive(x, y) ? '' : '@'));
            }
            pw.println();
        }

        System.out.print(sw);

    }

    /**
     * t@C琢𕜌܂B
     * @param file t@C
     * @return 
     * @throws IOException t@C̕Ɏsꍇ
     */
    private static Generation loadGeneration(String file) throws IOException {

        BufferedReader br = new BufferedReader(new FileReader(file));
        try {
            StringBuffer buffer = new StringBuffer();
            for (String line; (line = br.readLine()) != null;) {
                buffer.append(line);
            }
            return new Generation(buffer.toString());
        } catch (InstantiationException ex) {
            throw new IOException(ex.getMessage());
        } finally {
            br.close();
        }

    }

    /**
     * R\[ŃCtQ[N܂B
     * @param args Pw肳ꂽꍇ̓t@C
     */
    public static void main(String[] args) {

        try {

            Generation g;
            if (args.length > 0) {
                // t@Cw肠
                g = loadGeneration(args[0]);
            } else {
                // t@CwȂ
                g = new Generation(16, 8);
                Progress prog = new Progress(g);
                prog.shuffle(0.22);
            }

            // 100JԂ 0.5bEFCg
            Progress prog = new Progress(g);
            for (int i = 0; i < 100; i++) {
                print(prog.nextGeneration());
                try {
                    Thread.sleep(500);
                } catch (InterruptedException ex1) {
                }
            }

        } catch (InstantiationException ex) {
            ex.printStackTrace();
        } catch (IOException ex) {
            ex.printStackTrace();
        }

    }

}