package lifegame.view;

import java.awt.Color;

/**
 * CtQ[̐ݒłB
 * TCY̐ݒQȊO͌ĥ߂̂̂łB
 */
public final class Configuration {
    
    /**
     * EX̍őTCYłB
     */
    public static final int SIZE_X_MAX = 1024;
    
    /**
     * EX̍ŏTCYłB
     */
    public static final int SIZE_X_MIN = 8;
    
    /**
     * EY̍őTCYłB
     */
    public static final int SIZE_Y_MAX = 768;
    
    /**
     * EY̍ŏTCYłB
     */
    public static final int SIZE_Y_MIN = 8;
    
    /**
     * P}X̍őTCYłB
     */
    public static final int SIZE_DOT_MAX = 64;
    
    /**
     * P}X̍ŏTCYłB
     */
    public static final int SIZE_DOT_MIN = 1;

    /**
     * EX̃TCYłB
     */
    public int worldSizeX = 48;
    
    /**
     * EỸTCYłB
     */
    public int worldSizeY = 32;
    
    /**
     * P}X̃TCYłB
     */
    public int dotSize = 8;
    
    /**
     * }X̋ẼTCYłB
     */
    public int border = 0;
    
    /**
     * oߎԁi~bjłB
     */
    public long interval = 100;
    
    /**
     * Oʂ̐FiCt̂̐FjłB
     */
    public Color foreColor = Color.white;
    
    /**
     * wiFłB
     */
    public Color backGroundColor = Color.black;

    private boolean enable = false;

    /**
     * ݒftHglŐ܂B
     */
    public Configuration() {

    }

    /**
     * ݒ𕡐Đ܂B
     * @param configuration Rs[
     */
    public Configuration(Configuration configuration) {

        worldSizeX = configuration.worldSizeX;
        worldSizeY = configuration.worldSizeY;
        dotSize = configuration.dotSize;
        interval = configuration.interval;
        border = configuration.border;
        foreColor = configuration.foreColor;
        backGroundColor = configuration.backGroundColor;

    }

    /**
     * LTCݒ肵܂B
     * @param enable LTC
     */
    public void setEnable(boolean enable) {

        this.enable = enable;

    }

    /**
     * LTC擾܂B
     * @return LTC
     */
    public boolean isEnable() {

        return enable;

    }

    /**
     * ۗLl̑Ó𒲍܂B
     * @return ۗLSĂ̒lÓł<code>true</code>APłÓłȂ̂<code>false</code>
     */
    public boolean isValid() {

        int sizeX = worldSizeX * dotSize;
        if (sizeX < SIZE_X_MIN || sizeX > SIZE_X_MAX) {
            return false;
        }

        int sizeY = worldSizeY * dotSize;
        if (sizeY < SIZE_Y_MIN || sizeY > SIZE_Y_MAX) {
            return false;
        }

        if (dotSize < SIZE_DOT_MIN || dotSize > SIZE_DOT_MAX) {
            return false;
        }

        if (interval < 1) {
            return false;
        }

        if (border < 0) {
            return false;
        } else if (border >= dotSize) {
            return false;
        }

        if (foreColor == null) {
            return false;
        }

        if (backGroundColor == null) {
            return false;
        }

        return true;

    }

    /* ( Javadoc)
     * @see java.lang.Object#toString()
     */
    public String toString() {

        return "[ worldSizeX = " + worldSizeX +
                ", worldSizeY = " + worldSizeY +
                ", rate = " + dotSize +
                ", interval = " + interval +
                ", border = " + border +
                ", foreColor = " + foreColor +
                ", backGroundColor = " + backGroundColor + "]";

    }

}