package lifegame.core;

import java.util.Random;

/**
 * ̐is𐧌䂵܂B
 */
public class Progress {

    private Generation currentGeneration;

    /**
     * Progress𐶐܂B
     * @param generation (ŏ)
     */
    public Progress(Generation generation) {

        this.currentGeneration = generation;
    }

    /**
     * ̐Ԃ܂B
     * @return 
     * @throws InstantiationException Ɏsꍇ
     */
    public Generation nextGeneration() throws InstantiationException {

        Size s = currentGeneration.getSize();
        Generation nextGeneration = new Generation(s);

        for (int y = 0; y < s.getHeight(); y++) {
            for (int x = 0; x < s.getWidth(); x++) {
                if (hasNextGeneration(x, y)) {
                    nextGeneration.bear(x, y);
                } else {
                    nextGeneration.erase(x, y);
                }
            }
        }

        currentGeneration = nextGeneration;
        return nextGeneration;

    }

    /**
     * ɐ_ɔzu܂B
     * @param rate 
     */
    public void shuffle(double rate) {

        touchEffect(rate, true, true);

    }

    /**
     * ̐_ɑ܂B
     * @param rate 
     */
    public void increase(double rate) {

        touchEffect(rate, true, false);

    }

    /**
     * ̐_Ɍ܂B
     * @param rate 
     */
    public void decrease(double rate) {

        touchEffect(1 - rate, false, true);

    }

    /**
     * VbtEEȂǂ̃GtFNg܂B
     * @param rate 
     * @param bearing ꍇ <code>true</code>
     * @param erasing łꍇ <code>true</code>
     */
    private void touchEffect(double rate, boolean bearing, boolean erasing) {

        Random r = new Random();

        Size size = currentGeneration.getSize();
        for (int y = 0; y < size.getHeight(); y++) {
            for (int x = 0; x < size.getWidth(); x++) {
                if (rate > r.nextDouble()) {
                    if (bearing) {
                        currentGeneration.bear(x, y);
                    }
                } else {
                    if (erasing) {
                        currentGeneration.erase(x, y);
                    }
                }
            }
        }

    }

    /**
     * w肵W̎ɐ邩𒲍܂B
     * @param x XW
     * @param y YW
     * @return ɐꍇ <code>true</code>AȂꍇ <code>false</code>
     */
    private boolean hasNextGeneration(int x, int y) {

        int n = getNeighborHoodsNumber(x, y);

        if (currentGeneration.alive(x, y)) {

            if (n == 2 || n == 3) {
                return true;
            }

        } else {

            if (n == 3) {
                return true;
            }

        }

        return false;

    }

    /**
     * w肵ẂuߖTv̐擾܂B
     * @param x XW
     * @param y YW
     * @return 
     */
    private int getNeighborHoodsNumber(int x, int y) {

        int c = 0;

        c += (currentGeneration.alive(x - 1, y - 1) ? 1 : 0);
        c += (currentGeneration.alive(x    , y - 1) ? 1 : 0);
        c += (currentGeneration.alive(x + 1, y - 1) ? 1 : 0);
        c += (currentGeneration.alive(x - 1, y    ) ? 1 : 0);
        c += (currentGeneration.alive(x + 1, y    ) ? 1 : 0);
        c += (currentGeneration.alive(x - 1, y + 1) ? 1 : 0);
        c += (currentGeneration.alive(x    , y + 1) ? 1 : 0);
        c += (currentGeneration.alive(x + 1, y + 1) ? 1 : 0);

        return c;

    }

}