package lifegame.core;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

/**
 * \܂B 
 * IuWFNg͂Pɑ݂鐶̏ێ܂B
 */
public final class Generation {

    private static final String SEPARATOR = "/";
    private static final char ON = '1';
    private static final char OFF = '0';

    private int width;
    private int height;
    private boolean life[][];

    /**
     * 𐶐܂B
     * @param size TCY
     * @throws InstantiationException Ɏsꍇ
     */
    public Generation(Size size) throws InstantiationException {

        this(size.getWidth(), size.getHeight());

    }

    /**
     * 𐶐܂B
     * @param width 
     * @param height 
     * @throws InstantiationException Ɏsꍇ
     */
    public Generation(int width, int height) throws InstantiationException {

        this.width = width;
        this.height = height;

        try {
            life = new boolean[width][];
            for (int i = 0; i < width; i++) {
                life[i] = new boolean[height];
            }
        } catch (RuntimeException ex) {
            throw new InstantiationException(ex.getMessage());
        }

    }

    /**
     * 𐶐܂B
     * 񂩂IuWFNg𕜌ꍇɎgp܂B
     * @param string <code>Generation#toString()</code> Őꂽ
     * @throws InstantiationException Ɏsꍇ
     */
    public Generation(String string) throws InstantiationException {

        try {

            // s̃Xg쐬
            List lines = new ArrayList();
            StringTokenizer st = new StringTokenizer(string, SEPARATOR);
            while (st.hasMoreTokens()) {
                lines.add(st.nextToken());
            }
            String line1 = (String)lines.get(0);

            width = line1.length();
            height = lines.size();

            life = new boolean[width][];
            for (int x = 0; x < width; x++) {
                life[x] = new boolean[height];
            }

            for (int y = 0; y < height; y++) {
                String line = (String)lines.get(y);
                for (int x = 0; x < width; x++) {
                    char ch = line.charAt(x);
                    if (ch == ON) {
                        life[x][y] = true;
                    } else if (ch == OFF) {
                        life[x][y] = false;
                    } else {
                        throw new RuntimeException("format error");
                    }
                }
            }

        } catch (RuntimeException ex) {
            throw new InstantiationException(ex.getMessage());
        }

    }

    /**
     * ̐̃TCY擾܂B
     * @return TCY
     */
    public Size getSize() {

        return new Size(width, height);

    }

    /**
     * w肵Wɐ݂邩𒲍܂B
     * @param p W
     * @return ݂ <code>true</code>AȂ <code>false</code>
     */
    public boolean alive(Point p) {

        return alive(p.getX(), p.getY());

    }

    /**
     * w肵Wɐ݂邩𒲍܂B
     * @param x XW
     * @param y YW
     * @return ݂ <code>true</code>AȂ <code>false</code>
     */
    public boolean alive(int x, int y) {

        while (true) {
            if (x < 0) {
                x += width;
            } else if (x >= width) {
                x -= width;
            } else if (y < 0) {
                y += height;
            } else if (y >= height) {
                y -= height;
            } else {
                return life[x][y];
            }
        }

    }

    /**
     * w肵Wɐa܂B
     * łɐ݂ꍇ́A܂B
     * @param p W
     */
    public void bear(Point p) {

        bear(p.getX(), p.getY());

    }

    /**
     * w肵Wɐa܂B
     * łɐ݂ꍇ́A܂B
     * @param x XW
     * @param y YW
     */
    public void bear(int x, int y) {

        life[x][y] = true;

    }

    /**
     * w肵W̐𖕏܂B
     * ݂Ȃꍇ́A܂B
     * @param p W
     */
    public void erase(Point p) {

        erase(p.getX(), p.getY());

    }

    /**
     * w肵W̐𖕏܂B
     * @param x XW
     * @param y YW
     */
    public void erase(int x, int y) {

        life[x][y] = false;

    }

    /**
     * ̐NA܂B
     */
    public void clear() {

        for (int y = 0; y < height; y++) {
            for (int x = 0; x < width; x++) {
                life[x][y] = false;
            }
        }

    }

    /**
     * ̃IuWFNg̕\Ԃ܂B
     * 񉻌`ƂĂgp܂B
     */
    public String toString() {

        StringBuffer sb = new StringBuffer();

        for (int y = 0; y < height; y++) {
            for (int x = 0; x < width; x++) {
                sb.append(alive(x, y) ? ON : OFF);
            }
            sb.append(SEPARATOR);
        }

        return sb.toString();

    }

}