/*
 * Decompiled with CFR 0.152.
 */
package lifegame.view;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import lifegame.view.Configuration;

public class SizeConfigurationDialog
extends JDialog {
    private static final Font defaultFont = new Font("Monospaced", 0, 12);
    private static final String[] ERROR_MSG = new String[]{"\u5165\u529b\u5185\u5bb9\u306b\u30a8\u30e9\u30fc\u304c\u3042\u308a\u307e\u3059\u3000\u4ee5\u4e0b\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044", "\u30fb\u4e16\u754c\u306e\u30b5\u30a4\u30ba\u6a2a\u306f\u3001\u6a2a\u304b\u3051\u308b\u30e9\u30a4\u30d5\u306e\u30b5\u30a4\u30ba\u304c\u30018\uff5e1024\u306e\u7bc4\u56f2", "\u30fb\u4e16\u754c\u306e\u30b5\u30a4\u30ba\u7e26\u306f\u3001\u7e26\u304b\u3051\u308b\u30e9\u30a4\u30d5\u306e\u30b5\u30a4\u30ba\u304c\u30018\uff5e768\u306e\u7bc4\u56f2", "\u30fb\u30e9\u30a4\u30d5\u306e\u30b5\u30a4\u30ba\u306f\u30011\uff5e64\u306e\u7bc4\u56f2", "\u30fb\u5883\u754c\u7dda\u306f0\uff5e63\u306e\u7bc4\u56f2 (\u30e9\u30a4\u30d5\u306e\u30b5\u30a4\u30ba\u3088\u308a\u5927\u304d\u304f\u3067\u304d\u307e\u305b\u3093)"};
    private static final KeyStroke ESCAPE_KEY = KeyStroke.getKeyStroke(27, 0);
    private Configuration configuration;
    private JTextField verticalSize;
    private JTextField horizontalSize;
    private JTextField blockSize;
    private JTextField borderSize;

    public SizeConfigurationDialog(JFrame jFrame, Configuration configuration) {
        super(jFrame);
        this.configuration = configuration;
        ((Component)this).setSize(160, 240);
        this.setTitle("\u30b5\u30a4\u30ba\u5909\u66f4");
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.addKeyListener(new KeyListener(){

            private void onKey(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    SizeConfigurationDialog.this.dispose();
                }
            }

            public void keyTyped(KeyEvent keyEvent) {
                this.onKey(keyEvent);
            }

            public void keyPressed(KeyEvent keyEvent) {
                this.onKey(keyEvent);
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        JLabel jLabel = this.createLabel("\u4e16\u754c\u306e\u30b5\u30a4\u30ba");
        JLabel jLabel2 = this.createLabel("\u6a2a");
        JLabel jLabel3 = this.createLabel("\u7e26");
        JLabel jLabel4 = this.createLabel("\u30e9\u30a4\u30d5\u306e\u30b5\u30a4\u30ba");
        JLabel jLabel5 = this.createLabel("\u5927\u304d\u3055");
        JLabel jLabel6 = this.createLabel("\u5883\u754c\u7dda");
        this.horizontalSize = new JTextField(String.valueOf(configuration.worldSizeX), 4);
        this.verticalSize = new JTextField(String.valueOf(configuration.worldSizeY), 4);
        this.blockSize = new JTextField(String.valueOf(configuration.dotSize), 4);
        this.borderSize = new JTextField(String.valueOf(configuration.border), 4);
        FocusAdapter focusAdapter = new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                Object object = focusEvent.getSource();
                if (object instanceof JTextField) {
                    JTextField jTextField = (JTextField)focusEvent.getSource();
                    jTextField.selectAll();
                }
            }
        };
        this.horizontalSize.addFocusListener(focusAdapter);
        this.verticalSize.addFocusListener(focusAdapter);
        this.blockSize.addFocusListener(focusAdapter);
        this.borderSize.addFocusListener(focusAdapter);
        JButton jButton = new JButton("\u78ba\u5b9a");
        jButton.addActionListener(new AbstractAction(){
            Configuration c;
            {
                this.c = SizeConfigurationDialog.this.configuration;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.c.worldSizeX = SizeConfigurationDialog.this.parseInteger(SizeConfigurationDialog.this.horizontalSize.getText());
                this.c.worldSizeY = SizeConfigurationDialog.this.parseInteger(SizeConfigurationDialog.this.verticalSize.getText());
                this.c.dotSize = SizeConfigurationDialog.this.parseInteger(SizeConfigurationDialog.this.blockSize.getText());
                this.c.border = SizeConfigurationDialog.this.parseInteger(SizeConfigurationDialog.this.borderSize.getText());
                if (this.c.isValid()) {
                    this.c.setEnable(true);
                    SizeConfigurationDialog.this.dispose();
                } else {
                    JOptionPane.showConfirmDialog(SizeConfigurationDialog.this, ERROR_MSG, "\u5165\u529b\u30a8\u30e9\u30fc", -1);
                }
            }
        });
        JPanel jPanel = new JPanel(null);
        jPanel.add(jLabel);
        jPanel.add(jLabel2);
        jPanel.add(jLabel3);
        jPanel.add(this.verticalSize);
        jPanel.add(this.horizontalSize);
        jPanel.add(jLabel4);
        jPanel.add(jLabel5);
        jPanel.add(jLabel6);
        jPanel.add(this.blockSize);
        jPanel.add(this.borderSize);
        jPanel.add(jButton);
        boolean bl = false;
        int n = 16;
        jLabel.setBounds(8, n, 100, 20);
        jLabel2.setBounds(24, n += 20, 48, 20);
        this.horizontalSize.setBounds(64, n, 48, 20);
        jLabel3.setBounds(24, n += 20, 48, 20);
        this.verticalSize.setBounds(64, n, 48, 20);
        n += 20;
        jLabel4.setBounds(8, n += 20, 100, 20);
        jLabel5.setBounds(24, n += 20, 48, 20);
        this.blockSize.setBounds(64, n, 48, 20);
        jLabel6.setBounds(24, n += 20, 48, 20);
        this.borderSize.setBounds(64, n, 48, 20);
        n += 20;
        jButton.setBounds(28, n += 20, 100, 20);
        this.getContentPane().add((Component)jPanel, "Center");
        this.horizontalSize.requestFocus();
    }

    private JLabel createLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(defaultFont);
        return jLabel;
    }

    private int parseInteger(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }
}

