/*
 * Decompiled with CFR 0.152.
 */
package lifegame.view;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import lifegame.view.Configuration;

public class IntervalTimeDialog
extends JDialog {
    private static final String TITLE = "\u7d4c\u904e\u901f\u5ea6";
    private static final Font defaultFont = new Font("Monospaced", 0, 12);
    private static final int MAXIMUM = 1000;
    private static final int MINIMUM = 0;
    private JTextField intervalMilliSeconds;
    private JSlider slider;
    private Configuration configuration;

    public IntervalTimeDialog(JFrame jFrame, Configuration configuration) {
        super(jFrame);
        this.configuration = configuration;
        int n = (int)configuration.interval;
        ((Component)this).setSize(200, 100);
        this.setTitle(TITLE);
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.addKeyListener(new KeyListener(){

            private void onKey(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    IntervalTimeDialog.this.dispose();
                }
            }

            public void keyTyped(KeyEvent keyEvent) {
                this.onKey(keyEvent);
            }

            public void keyPressed(KeyEvent keyEvent) {
                this.onKey(keyEvent);
            }

            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        JLabel jLabel = new JLabel("\u30df\u30ea\u79d2\uff0f\uff11\u4e16\u4ee3");
        jLabel.setFont(defaultFont);
        this.intervalMilliSeconds = new JTextField(String.valueOf(n), 4);
        this.intervalMilliSeconds.addFocusListener(new FocusAdapter(){
            JTextField t;
            JSlider s;
            Configuration conf;
            {
                this.t = IntervalTimeDialog.this.intervalMilliSeconds;
                this.s = IntervalTimeDialog.this.slider;
                this.conf = new Configuration();
            }

            public void focusLost(FocusEvent focusEvent) {
                try {
                    this.conf.interval = Long.parseLong(IntervalTimeDialog.this.intervalMilliSeconds.getText());
                    if (this.conf.isValid()) {
                        IntervalTimeDialog.this.slider.setValue((int)this.conf.interval);
                        ((IntervalTimeDialog)IntervalTimeDialog.this).configuration.interval = this.conf.interval;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace(System.err);
                }
            }
        });
        this.slider = new JSlider(0, 1000, n);
        this.slider.setPaintTicks(true);
        this.slider.setMajorTickSpacing(500);
        this.slider.setMinorTickSpacing(50);
        this.slider.addChangeListener(new ChangeListener(){
            JTextField text;
            Configuration conf;
            {
                this.text = IntervalTimeDialog.this.intervalMilliSeconds;
                this.conf = new Configuration();
            }

            public void stateChanged(ChangeEvent changeEvent) {
                JSlider jSlider = (JSlider)changeEvent.getSource();
                this.conf.interval = jSlider.getValue();
                this.text.setText(String.valueOf(this.conf.interval));
                if (this.conf.isValid()) {
                    ((IntervalTimeDialog)IntervalTimeDialog.this).configuration.interval = this.conf.interval;
                }
            }
        });
        JPanel jPanel = new JPanel(null);
        jPanel.add(jLabel);
        jPanel.add(this.slider);
        jPanel.add(this.intervalMilliSeconds);
        this.intervalMilliSeconds.setBounds(32, 8, 40, 20);
        jLabel.setBounds(76, 8, 100, 20);
        this.slider.setBounds(8, 32, 176, 40);
        this.getContentPane().add((Component)jPanel, "Center");
    }
}

