/*
 * Decompiled with CFR 0.152.
 */
package lifegame.view;

import java.awt.Color;

public final class Configuration {
    public static final int SIZE_X_MAX = 1024;
    public static final int SIZE_X_MIN = 8;
    public static final int SIZE_Y_MAX = 768;
    public static final int SIZE_Y_MIN = 8;
    public static final int SIZE_DOT_MAX = 64;
    public static final int SIZE_DOT_MIN = 1;
    public int worldSizeX = 48;
    public int worldSizeY = 32;
    public int dotSize = 8;
    public int border = 0;
    public long interval = 100L;
    public Color foreColor = Color.white;
    public Color backGroundColor = Color.black;
    private boolean enable = false;

    public Configuration() {
    }

    public Configuration(Configuration configuration) {
        this.worldSizeX = configuration.worldSizeX;
        this.worldSizeY = configuration.worldSizeY;
        this.dotSize = configuration.dotSize;
        this.interval = configuration.interval;
        this.border = configuration.border;
        this.foreColor = configuration.foreColor;
        this.backGroundColor = configuration.backGroundColor;
    }

    public void setEnable(boolean bl) {
        this.enable = bl;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public boolean isValid() {
        int n = this.worldSizeX * this.dotSize;
        if (n < 8 || n > 1024) {
            return false;
        }
        int n2 = this.worldSizeY * this.dotSize;
        if (n2 < 8 || n2 > 768) {
            return false;
        }
        if (this.dotSize < 1 || this.dotSize > 64) {
            return false;
        }
        if (this.interval < 1L) {
            return false;
        }
        if (this.border < 0) {
            return false;
        }
        if (this.border >= this.dotSize) {
            return false;
        }
        if (this.foreColor == null) {
            return false;
        }
        return this.backGroundColor != null;
    }

    public String toString() {
        return "[ worldSizeX = " + this.worldSizeX + ", worldSizeY = " + this.worldSizeY + ", rate = " + this.dotSize + ", interval = " + this.interval + ", border = " + this.border + ", foreColor = " + this.foreColor + ", backGroundColor = " + this.backGroundColor + "]";
    }
}

