/*
 * Decompiled with CFR 0.152.
 */
package lifegame.core;

import java.util.Random;
import lifegame.core.Generation;
import lifegame.core.Size;

public class Progress {
    private Generation currentGeneration;

    public Progress(Generation generation) {
        this.currentGeneration = generation;
    }

    public Generation nextGeneration() throws InstantiationException {
        Size size = this.currentGeneration.getSize();
        Generation generation = new Generation(size);
        int n = 0;
        while (n < size.getHeight()) {
            int n2 = 0;
            while (n2 < size.getWidth()) {
                if (this.hasNextGeneration(n2, n)) {
                    generation.bear(n2, n);
                } else {
                    generation.erase(n2, n);
                }
                ++n2;
            }
            ++n;
        }
        this.currentGeneration = generation;
        return generation;
    }

    public void shuffle(double d) {
        this.touchEffect(d, true, true);
    }

    public void increase(double d) {
        this.touchEffect(d, true, false);
    }

    public void decrease(double d) {
        this.touchEffect(1.0 - d, false, true);
    }

    private void touchEffect(double d, boolean bl, boolean bl2) {
        Random random = new Random();
        Size size = this.currentGeneration.getSize();
        int n = 0;
        while (n < size.getHeight()) {
            int n2 = 0;
            while (n2 < size.getWidth()) {
                if (d > random.nextDouble()) {
                    if (bl) {
                        this.currentGeneration.bear(n2, n);
                    }
                } else if (bl2) {
                    this.currentGeneration.erase(n2, n);
                }
                ++n2;
            }
            ++n;
        }
    }

    private boolean hasNextGeneration(int n, int n2) {
        int n3 = this.getNeighborHoodsNumber(n, n2);
        return this.currentGeneration.alive(n, n2) ? n3 == 2 || n3 == 3 : n3 == 3;
    }

    private int getNeighborHoodsNumber(int n, int n2) {
        int n3 = 0;
        n3 += this.currentGeneration.alive(n - 1, n2 - 1) ? 1 : 0;
        n3 += this.currentGeneration.alive(n, n2 - 1) ? 1 : 0;
        n3 += this.currentGeneration.alive(n + 1, n2 - 1) ? 1 : 0;
        n3 += this.currentGeneration.alive(n - 1, n2) ? 1 : 0;
        n3 += this.currentGeneration.alive(n + 1, n2) ? 1 : 0;
        n3 += this.currentGeneration.alive(n - 1, n2 + 1) ? 1 : 0;
        n3 += this.currentGeneration.alive(n, n2 + 1) ? 1 : 0;
        return n3 += this.currentGeneration.alive(n + 1, n2 + 1) ? 1 : 0;
    }
}

