package lifegame.view;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.JPanel;

import lifegame.core.Generation;
import lifegame.core.Progress;
import lifegame.core.Size;

/**
 * }EX󂯕tQ[ՖʂłB
 * CtQ[̂߂̕\ƃ}EX܂B
 */
public class MouseListeningPanel extends JPanel implements Runnable {

    Generation generation; // pbP[WANZX

    private Configuration configuration;
    private boolean isRunning;

    /**
     * MouseListeningPanel𐶐܂B
     */
    public MouseListeningPanel(Configuration configuration) {

        this.configuration = configuration;

        setBackground(configuration.backGroundColor);

        try {
            generation = new Generation(configuration.worldSizeX,
                    configuration.worldSizeY);
        } catch (InstantiationException ex) {
            throw new IllegalArgumentException(configuration.toString());
        }

        addMouseListener(new MouseAdapter() {

            /* ( Javadoc)
             * @see java.awt.event.MouseListener#mousePressed(java.awt.event.MouseEvent)
             */
            public void mousePressed(MouseEvent e) {

                Point p = e.getPoint();

                int x = (int)(p.x / getConfiguration().dotSize);
                int y = (int)(p.y / getConfiguration().dotSize);

                if (generation.alive(x, y)) {
                    generation.erase(x, y);
                } else {
                    generation.bear(x, y);
                }
                repaint();

            }
            
        });

    }

    /**
     * sǂ𒲍܂B
     * @return isRunning sȂ<code>true</code>
     */
    public boolean isRunning() {

        return isRunning;

    }

    /**
     * sǂݒ肵܂B
     * @param isRunning sȂ<code>true</code>
     */
    public void setRunning(boolean isRunning) {

        this.isRunning = isRunning;

    }

    /**
     * ݒ擾܂B
     * iNX̃ANZX̂߁j
     * @return ݒ
     */
    private Configuration getConfiguration() {

        return configuration;
        
    }

    /**
     * Pi߂܂B
     */
    public void proceed() {

        Progress progress = new Progress(generation);
        try {
            generation = progress.nextGeneration();
        } catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        repaint();

    }

    /* ( Javadoc)
     * @see javax.swing.JComponent#paintComponent(java.awt.Graphics)
     */
    protected void paintComponent(Graphics g) {

        super.paintComponent(g);

        Size s = generation.getSize();

        g.setColor(configuration.foreColor);

        int border = configuration.border / 2;
        int rectSize = (configuration.dotSize - configuration.border > 0 ? configuration.dotSize
                - configuration.border
                : 1);

        for (int y = 0; y < s.getHeight(); y++) {
            for (int x = 0; x < s.getWidth(); x++) {
                if (generation.alive(x, y)) {
                    g.fillRect(x * configuration.dotSize + border, y
                            * configuration.dotSize + border, rectSize,
                            rectSize);
                }
            }
        }

    }

    /* ( Javadoc)
     * @see java.lang.Runnable#run()
     */
    public void run() {

        while (isRunning) {

            proceed();

            try {
                Thread.sleep(configuration.interval);
            } catch (InterruptedException ex) {
            }

        }

    }

}