/*
 * Decompiled with CFR 0.152.
 */
package lifegame.view;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import lifegame.core.Generation;
import lifegame.core.Progress;
import lifegame.core.Size;
import lifegame.view.Configuration;

public class MouseListeningPanel
extends JPanel
implements Runnable {
    Generation generation;
    private Configuration configuration;
    private boolean isRunning;

    public MouseListeningPanel(Configuration configuration) {
        this.configuration = configuration;
        this.setBackground(configuration.backGroundColor);
        try {
            this.generation = new Generation(configuration.worldSizeX, configuration.worldSizeY);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException(configuration.toString());
        }
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = point.x / ((MouseListeningPanel)MouseListeningPanel.this).getConfiguration().dotSize;
                int n2 = point.y / ((MouseListeningPanel)MouseListeningPanel.this).getConfiguration().dotSize;
                if (MouseListeningPanel.this.generation.alive(n, n2)) {
                    MouseListeningPanel.this.generation.erase(n, n2);
                } else {
                    MouseListeningPanel.this.generation.bear(n, n2);
                }
                MouseListeningPanel.this.repaint();
            }
        });
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void setRunning(boolean bl) {
        this.isRunning = bl;
    }

    private Configuration getConfiguration() {
        return this.configuration;
    }

    public void proceed() {
        Progress progress = new Progress(this.generation);
        try {
            this.generation = progress.nextGeneration();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        this.repaint();
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Size size = this.generation.getSize();
        graphics.setColor(this.configuration.foreColor);
        int n = this.configuration.border / 2;
        int n2 = this.configuration.dotSize - this.configuration.border > 0 ? this.configuration.dotSize - this.configuration.border : 1;
        int n3 = 0;
        while (n3 < size.getHeight()) {
            int n4 = 0;
            while (n4 < size.getWidth()) {
                if (this.generation.alive(n4, n3)) {
                    graphics.fillRect(n4 * this.configuration.dotSize + n, n3 * this.configuration.dotSize + n, n2, n2);
                }
                ++n4;
            }
            ++n3;
        }
    }

    public void run() {
        while (this.isRunning) {
            this.proceed();
            try {
                Thread.sleep(this.configuration.interval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

