/*
 * Decompiled with CFR 0.152.
 */
package lifegame.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.filechooser.FileFilter;
import lifegame.core.Generation;
import lifegame.core.Progress;
import lifegame.core.Size;
import lifegame.view.Configuration;
import lifegame.view.IntervalTimeDialog;
import lifegame.view.MouseListeningPanel;
import lifegame.view.SizeConfigurationDialog;

public class GraphicalView
extends JFrame {
    private static final String TITLE = "LifeGame";
    private static final String FILE_SUFFIX = ".lif";
    private static final Font menuFont = new Font("Monospaced", 0, 12);
    private static final KeyStroke SPACE_KEY = KeyStroke.getKeyStroke(32, 0);
    private static final KeyStroke CTRL_K_KEY = KeyStroke.getKeyStroke(75, 2);
    private static final KeyStroke CTRL_M_KEY = KeyStroke.getKeyStroke(77, 2);
    private static final KeyStroke CTRL_O_KEY = KeyStroke.getKeyStroke(79, 2);
    private static final KeyStroke CTRL_P_KEY = KeyStroke.getKeyStroke(80, 2);
    private static final KeyStroke CTRL_R_KEY = KeyStroke.getKeyStroke(82, 2);
    private static final KeyStroke CTRL_S_KEY = KeyStroke.getKeyStroke(83, 2);
    private Configuration configuration;
    private File currentDirectory;
    private JMenuBar menuBar;
    private JPanel topPanel;
    private MouseListeningPanel panel;
    private FileFilter fileFilter = new FileFilter(){

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(GraphicalView.FILE_SUFFIX);
        }

        public String getDescription() {
            return "\u30e9\u30a4\u30d5\u30b2\u30fc\u30e0 \u30c7\u30fc\u30bf (*.lif)";
        }
    };

    public GraphicalView() {
        this.configuration = new Configuration();
        this.currentDirectory = new File(System.getProperty("user.dir"));
        this.topPanel = new JPanel(null);
        this.getContentPane().add(this.topPanel);
        JMenu jMenu = new JMenu("\u30d5\u30a1\u30a4\u30eb(F)");
        jMenu.setMnemonic('F');
        jMenu.add(this.createJMenuItem("\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u304f(O)", 'O', CTRL_O_KEY, new AbstractAction(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser(GraphicalView.this.currentDirectory);
                jFileChooser.setDialogTitle("\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u304f");
                jFileChooser.setApproveButtonText("\u958b\u304f");
                jFileChooser.setFileSelectionMode(0);
                jFileChooser.setFileFilter(GraphicalView.this.fileFilter);
                jFileChooser.showDialog(GraphicalView.this, null);
                File file = jFileChooser.getSelectedFile();
                if (file == null) {
                    return;
                }
                GraphicalView.this.currentDirectory = file.getParentFile();
                try {
                    BufferedReader bufferedReader;
                    block10: {
                        block9: {
                            bufferedReader = new BufferedReader(new FileReader(file));
                            try {
                                Generation generation;
                                block8: {
                                    StringBuffer stringBuffer = new StringBuffer();
                                    while (true) {
                                        String string;
                                        if ((string = bufferedReader.readLine()) == null) {
                                            generation = new Generation(stringBuffer.toString());
                                            Size size = generation.getSize();
                                            if (!((GraphicalView)GraphicalView.this).panel.generation.getSize().equals(size)) {
                                                Configuration configuration = new Configuration(GraphicalView.this.configuration);
                                                configuration.worldSizeX = size.getWidth();
                                                configuration.worldSizeY = size.getHeight();
                                                if (!configuration.isValid()) break;
                                                ((GraphicalView)GraphicalView.this).configuration.worldSizeX = size.getWidth();
                                                ((GraphicalView)GraphicalView.this).configuration.worldSizeY = size.getHeight();
                                                GraphicalView.this.initialize();
                                            }
                                            break block8;
                                        }
                                        stringBuffer.append(string);
                                    }
                                    JOptionPane.showConfirmDialog(GraphicalView.this, "\u73fe\u5728\u306e\u30b5\u30a4\u30ba\u8a2d\u5b9a\u3067\u306f\u3053\u306e\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u3051\u307e\u305b\u3093", "\u30a8\u30e9\u30fc", -1);
                                    Object var11_11 = null;
                                    break block9;
                                }
                                ((GraphicalView)GraphicalView.this).panel.generation = generation;
                                GraphicalView.this.panel.repaint();
                                break block10;
                            }
                            catch (Throwable throwable) {
                                Object var11_13 = null;
                                bufferedReader.close();
                                throw throwable;
                            }
                        }
                        bufferedReader.close();
                        return;
                    }
                    Object var11_12 = null;
                    bufferedReader.close();
                    return;
                }
                catch (Exception exception) {
                    JOptionPane.showConfirmDialog(GraphicalView.this, new String[]{exception.getMessage() + " \u306e\u305f\u3081", "\u30d5\u30a1\u30a4\u30eb\u304c\u958b\u3051\u307e\u305b\u3093\u3067\u3057\u305f"}, "\u30a8\u30e9\u30fc", -1);
                }
            }
        }));
        jMenu.add(this.createJMenuItem("\u30d5\u30a1\u30a4\u30eb\u306b\u4fdd\u5b58(S)", 'S', CTRL_S_KEY, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser(GraphicalView.this.currentDirectory);
                jFileChooser.setDialogTitle("\u30d5\u30a1\u30a4\u30eb\u306b\u4fdd\u5b58");
                jFileChooser.setApproveButtonText("\u4fdd\u5b58");
                jFileChooser.setFileSelectionMode(0);
                jFileChooser.setFileFilter(GraphicalView.this.fileFilter);
                jFileChooser.showDialog(GraphicalView.this, null);
                File file = jFileChooser.getSelectedFile();
                if (file == null) {
                    return;
                }
                GraphicalView.this.currentDirectory = file.getParentFile();
                try {
                    int n;
                    if (!file.getName().toLowerCase().endsWith(GraphicalView.FILE_SUFFIX)) {
                        file = new File(file.getParent(), file.getName() + GraphicalView.FILE_SUFFIX);
                    }
                    if (file.exists() && (n = JOptionPane.showConfirmDialog(GraphicalView.this, new String[]{"\u30d5\u30a1\u30a4\u30eb\u306f\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059", "\u4e0a\u66f8\u304d\u3057\u3066\u3088\u308d\u3057\u3044\u3067\u3059\u304b\uff1f"}, "\u30d5\u30a1\u30a4\u30eb\u306e\u4e0a\u66f8\u304d", 0)) != 0) {
                        return;
                    }
                    PrintWriter printWriter = new PrintWriter(new FileWriter(file));
                    try {
                        printWriter.print(((GraphicalView)GraphicalView.this).panel.generation);
                        Object var6_7 = null;
                        printWriter.close();
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        printWriter.close();
                        throw throwable;
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }));
        jMenu.add(new JSeparator());
        jMenu.add(this.createJMenuItem("\u7d42\u4e86(X)", 'X', null, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphicalView.this.dispose();
                System.exit(0);
            }
        }));
        JMenu jMenu2 = new JMenu("\u30b2\u30fc\u30e0(G)");
        jMenu.setMnemonic('G');
        jMenu2.add(this.createJMenuItem("\u30b9\u30bf\u30fc\u30c8/\u30b9\u30c8\u30c3\u30d7(S)", 'S', SPACE_KEY, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphicalView.this.panel.setRunning(!GraphicalView.this.panel.isRunning());
                Thread thread = new Thread(GraphicalView.this.panel);
                thread.start();
                GraphicalView.this.setTitle(GraphicalView.TITLE + (GraphicalView.this.panel.isRunning() ? " (live) " : ""));
            }
        }));
        jMenu2.add(new JSeparator());
        jMenu2.add(this.createJMenuItem("\u30b7\u30e3\u30c3\u30d5\u30eb(R)", 'R', CTRL_K_KEY, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Progress progress = new Progress(((GraphicalView)GraphicalView.this).panel.generation);
                progress.shuffle(0.087);
                GraphicalView.this.panel.repaint();
            }
        }));
        jMenu2.add(this.createJMenuItem("\u5897\u52a0(I)", 'I', CTRL_P_KEY, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Progress progress = new Progress(((GraphicalView)GraphicalView.this).panel.generation);
                progress.increase(0.01);
                GraphicalView.this.panel.repaint();
            }
        }));
        jMenu2.add(this.createJMenuItem("\u6e1b\u5c11(D)", 'D', CTRL_M_KEY, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Progress progress = new Progress(((GraphicalView)GraphicalView.this).panel.generation);
                progress.decrease(0.01);
                GraphicalView.this.panel.repaint();
            }
        }));
        jMenu2.add(this.createJMenuItem("\u30af\u30ea\u30a2(C)", 'C', null, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((GraphicalView)GraphicalView.this).panel.generation.clear();
                GraphicalView.this.panel.repaint();
            }
        }));
        JMenu jMenu3 = new JMenu("\u8a2d\u5b9a(C)");
        jMenu3.setMnemonic('C');
        jMenu3.add(this.createJMenuItem("\u30e9\u30a4\u30d5\u306e\u8272\u3092\u5909\u66f4(L)", 'L', null, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(null, "\u30e9\u30a4\u30d5\u306e\u8272", ((GraphicalView)GraphicalView.this).configuration.foreColor);
                if (color != null) {
                    ((GraphicalView)GraphicalView.this).configuration.foreColor = color;
                    GraphicalView.this.panel.repaint();
                }
            }
        }));
        jMenu3.add(this.createJMenuItem("\u80cc\u666f\u8272\u3092\u5909\u66f4(B)", 'B', null, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(null, "\u80cc\u666f\u8272", ((GraphicalView)GraphicalView.this).configuration.foreColor);
                if (color != null) {
                    ((GraphicalView)GraphicalView.this).configuration.backGroundColor = color;
                    GraphicalView.this.panel.setBackground(color);
                    GraphicalView.this.panel.repaint();
                }
            }
        }));
        jMenu3.add(this.createJMenuItem("\u7d4c\u904e\u901f\u5ea6\u3092\u5909\u66f4(T)", 'T', null, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphicalView graphicalView = GraphicalView.this;
                IntervalTimeDialog intervalTimeDialog = new IntervalTimeDialog(graphicalView, GraphicalView.this.configuration);
                ((Component)intervalTimeDialog).setLocation(graphicalView.getX() + 160, GraphicalView.this.getY() + 40);
                intervalTimeDialog.setModal(true);
                intervalTimeDialog.show();
            }
        }));
        jMenu3.add(new JSeparator());
        jMenu3.add(this.createJMenuItem("\u30b5\u30a4\u30ba\u5909\u66f4(R)", 'R', CTRL_R_KEY, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = JOptionPane.showConfirmDialog(GraphicalView.this, new String[]{"\u73fe\u5728\u306e\u5185\u5bb9\u304c\u30af\u30ea\u30a2\u3055\u308c\u307e\u3059\u304c", "\u3088\u308d\u3057\u3044\u3067\u3059\u304b\uff1f"}, "\u30b5\u30a4\u30ba\u5909\u66f4", 0);
                if (n == 0) {
                    Configuration configuration = new Configuration(GraphicalView.this.configuration);
                    GraphicalView graphicalView = GraphicalView.this;
                    SizeConfigurationDialog sizeConfigurationDialog = new SizeConfigurationDialog(graphicalView, configuration);
                    ((Component)sizeConfigurationDialog).setLocation(graphicalView.getX() + 100, GraphicalView.this.getY());
                    sizeConfigurationDialog.setModal(true);
                    sizeConfigurationDialog.show();
                    if (configuration.isEnable() && configuration.isValid()) {
                        GraphicalView.this.configuration = configuration;
                        GraphicalView.this.initialize();
                    }
                }
            }
        }));
        JMenu jMenu4 = new JMenu("\u30d8\u30eb\u30d7(H)");
        jMenu4.setMnemonic('H');
        jMenu4.add(this.createJMenuItem("LifeGame \u306b\u3064\u3044\u3066(A)", 'A', null, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                String[] stringArray = new String[]{GraphicalView.TITLE, "version 1.0"};
                JOptionPane jOptionPane = new JOptionPane(stringArray, 1, -1);
                jOptionPane.setIcon(new ImageIcon(GraphicalView.this.getIconImage()));
                JDialog jDialog = jOptionPane.createDialog(GraphicalView.this, GraphicalView.TITLE);
                jDialog.show();
            }
        }));
        this.menuBar = new JMenuBar();
        this.menuBar.add(jMenu);
        this.menuBar.add(jMenu2);
        this.menuBar.add(jMenu3);
        this.menuBar.add(jMenu4);
        this.setJMenuBar(this.menuBar);
        this.adjustAllMenuElement(this.menuBar);
        this.setTitle(TITLE);
        this.setResizable(false);
        this.setDefaultCloseOperation(3);
        Image image = this.getImage();
        if (image != null) {
            ((Frame)this).setIconImage(image);
        }
        this.initialize();
    }

    private void initialize() {
        ((Component)this).setSize(this.configuration.worldSizeX * this.configuration.dotSize + 9, this.configuration.worldSizeY * this.configuration.dotSize + 50);
        boolean bl = false;
        if (this.panel != null) {
            bl = this.panel.isRunning();
            this.panel.setRunning(false);
            this.topPanel.remove(this.panel);
            this.panel = new MouseListeningPanel(this.configuration);
            this.panel.setRunning(bl);
            Thread thread = new Thread(this.panel);
            thread.start();
            this.setTitle(TITLE + (this.panel.isRunning() ? " (live) " : ""));
        } else {
            this.panel = new MouseListeningPanel(this.configuration);
        }
        this.topPanel.add(this.panel);
        this.panel.setBounds(1, 0, this.configuration.worldSizeX * this.configuration.dotSize, this.configuration.worldSizeY * this.configuration.dotSize);
        this.validate();
    }

    private Image getImage() {
        try {
            String string = "/lifegame/view/icon.gif";
            URL uRL = this.getClass().getResource(string);
            return Toolkit.getDefaultToolkit().getImage(uRL);
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    private JMenuItem createJMenuItem(String string, char c, KeyStroke keyStroke, Action action) {
        JMenuItem jMenuItem = new JMenuItem(string, c);
        if (keyStroke != null) {
            jMenuItem.setAccelerator(keyStroke);
        }
        if (action != null) {
            jMenuItem.addActionListener(action);
        }
        return jMenuItem;
    }

    private void adjustAllMenuElement(MenuElement menuElement) {
        MenuElement[] menuElementArray = menuElement.getSubElements();
        int n = 0;
        int n2 = menuElementArray.length;
        while (n < n2) {
            MenuElement menuElement2 = menuElementArray[n];
            menuElement2.getComponent().setFont(menuFont);
            this.adjustAllMenuElement(menuElement2);
            ++n;
        }
    }

    public static void main(String[] stringArray) {
        GraphicalView graphicalView = new GraphicalView();
        ((Component)graphicalView).setLocation(200, 100);
        graphicalView.show();
    }
}

