/*
 * Decompiled with CFR 0.152.
 */
package lifegame.core;

import java.util.ArrayList;
import java.util.StringTokenizer;
import lifegame.core.Point;
import lifegame.core.Size;

public final class Generation {
    private static final String SEPARATOR = "/";
    private static final char ON = '1';
    private static final char OFF = '0';
    private int width;
    private int height;
    private boolean[][] life;

    public Generation(Size size) throws InstantiationException {
        this(size.getWidth(), size.getHeight());
    }

    public Generation(int n, int n2) throws InstantiationException {
        this.width = n;
        this.height = n2;
        try {
            this.life = new boolean[n][];
            int n3 = 0;
            while (n3 < n) {
                this.life[n3] = new boolean[n2];
                ++n3;
            }
        }
        catch (RuntimeException runtimeException) {
            throw new InstantiationException(runtimeException.getMessage());
        }
    }

    public Generation(String string) throws InstantiationException {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, SEPARATOR);
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            String string2 = (String)arrayList.get(0);
            this.width = string2.length();
            this.height = arrayList.size();
            this.life = new boolean[this.width][];
            int n = 0;
            while (n < this.width) {
                this.life[n] = new boolean[this.height];
                ++n;
            }
            int n2 = 0;
            while (n2 < this.height) {
                String string3 = (String)arrayList.get(n2);
                int n3 = 0;
                while (n3 < this.width) {
                    char c = string3.charAt(n3);
                    if (c == '1') {
                        this.life[n3][n2] = true;
                    } else if (c == '0') {
                        this.life[n3][n2] = false;
                    } else {
                        throw new RuntimeException("format error");
                    }
                    ++n3;
                }
                ++n2;
            }
        }
        catch (RuntimeException runtimeException) {
            throw new InstantiationException(runtimeException.getMessage());
        }
    }

    public Size getSize() {
        return new Size(this.width, this.height);
    }

    public boolean alive(Point point) {
        return this.alive(point.getX(), point.getY());
    }

    public boolean alive(int n, int n2) {
        while (true) {
            if (n < 0) {
                n += this.width;
                continue;
            }
            if (n >= this.width) {
                n -= this.width;
                continue;
            }
            if (n2 < 0) {
                n2 += this.height;
                continue;
            }
            if (n2 < this.height) break;
            n2 -= this.height;
        }
        return this.life[n][n2];
    }

    public void bear(Point point) {
        this.bear(point.getX(), point.getY());
    }

    public void bear(int n, int n2) {
        this.life[n][n2] = true;
    }

    public void erase(Point point) {
        this.erase(point.getX(), point.getY());
    }

    public void erase(int n, int n2) {
        this.life[n][n2] = false;
    }

    public void clear() {
        int n = 0;
        while (n < this.height) {
            int n2 = 0;
            while (n2 < this.width) {
                this.life[n2][n] = false;
                ++n2;
            }
            ++n;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.height) {
            int n2 = 0;
            while (n2 < this.width) {
                stringBuffer.append(this.alive(n2, n) ? (char)'1' : '0');
                ++n2;
            }
            stringBuffer.append(SEPARATOR);
            ++n;
        }
        return stringBuffer.toString();
    }
}

