package net.argius.filetool;

import java.io.*;
import java.util.*;

import org.apache.tools.zip.*;

/**
 * ZipA[JCuWJB
 * AntAPIgpZIP`̃A[JCuWJB
 */
public final class ZipExpander implements Expander {

    private ZipFile zfile;
    private Enumeration entries;
    private ZipEntry currentEntry;

    /**
     * ZipExpander̐B
     * @param src zipt@C
     * @throws IOException o̓G[ꍇ 
     */
    public ZipExpander(File src) throws IOException {
        this.zfile = new ZipFile(src);
        this.entries = zfile.getEntries();
    }

    /* (overridden)
     * @see net.argius.filetool.compress.Expander#nextEntry()
     */
    public ArchiveEntry nextEntry() throws IOException {
        if (!entries.hasMoreElements()) {
            return ArchiveEntry.EMPTY;
        }
        ZipEntry entry = (ZipEntry)entries.nextElement();
        ArchiveEntry ae = new ArchiveEntry(entry.getName());
        ae.setLastModified(entry.getTime());
        currentEntry = entry;
        return ae;
    }

    /* (overridden)
     * @see net.argius.filetool.compress.Expander#expand(java.io.OutputStream)
     */
    public long expand(OutputStream os) throws IOException {
        return IOUtilities.transferAll(zfile.getInputStream(currentEntry), os);
    }

    /* (overridden)
     * @see net.argius.filetool.compress.Expander#close()
     */
    public void close() throws IOException {
        zfile.close();
    }

}
