package net.argius.filetool;

import java.io.*;

import org.apache.tools.tar.*;

/**
 * TarA[JCuWJB
 * AntAPIgpTAR`̃A[JCuWJB
 */
public final class TarExpander implements Expander {

    private TarInputStream tis;

    /**
     * TarExpander̐B
     * @param is ̓Xg[
     */
    public TarExpander(InputStream is) {
        this.tis = new TarInputStream(is);
    }

    /* (overridden)
     * @see net.argius.filetool.compress.Expander#nextEntry()
     */
    public ArchiveEntry nextEntry() throws IOException {
        TarEntry entry = tis.getNextEntry();
        if (entry == null) {
            return ArchiveEntry.EMPTY;
        }
        ArchiveEntry ae = new ArchiveEntry(entry.getName());
        ae.setLastModified(entry.getModTime().getTime());
        return ae;
    }

    /* (overridden)
     * @see net.argius.filetool.compress.Expander#expand(java.io.OutputStream)
     */
    public long expand(OutputStream os) throws IOException {
        return IOUtilities.transferAll(tis, os);
    }

    /* (overridden)
     * @see net.argius.filetool.compress.Expander#close()
     */
    public void close() throws IOException {
        tis.close();
    }

}
