package net.argius.filetool;

import java.io.*;

import org.apache.tools.tar.*;

/**
 * TarA[JCoB
 * AntAPIgpTAR`̃A[JCu쐬B
 */
public final class TarArchiver implements Archiver {

    private TarOutputStream tos;
    private boolean includesDirectory;

    /**
     * TarArchiver̐B
     * @param os o͐Xg[
     */
    public TarArchiver(OutputStream os) {
        this.tos = new TarOutputStream(os);
        this.includesDirectory = true;
    }

    /**
     * includesDirectory̐ݒB
     * @param includesDirectory includesDirectory
     */
    public void setIncludesDirectory(boolean includesDirectory) {
        this.includesDirectory = includesDirectory;
    }

    /* (overridden)
     * @see net.argius.filetool.compress.Archiver#addEntry(net.argius.filetool.compress.ArchiverEntry, java.io.InputStream, int, long)
     */
    public void addEntry(ArchiveEntry ae, InputStream is, long length) throws IOException {
        if (ae.isDirectory()) {
            // fBNg
            if (includesDirectory) {
                TarEntry entry = new TarEntry(ae.getName());
                entry.setMode(TarEntry.DEFAULT_DIR_MODE);
                entry.setModTime(ae.getLastModified());
                tos.putNextEntry(entry);
                tos.closeEntry();
            }
        } else {
            // t@C
            TarEntry entry = new TarEntry(ae.getName());
            entry.setSize(length);
            entry.setModTime(ae.getLastModified());
            tos.putNextEntry(entry);
            IOUtilities.transferAll(is, tos);
            tos.closeEntry();
        }
    }

    /* (overridden)
     * @see java.io.Closeable#close()
     */
    public void close() throws IOException {
        tos.close();
    }

}
