package net.argius.filetool;

import java.io.*;

import jp.gr.java_conf.dangan.util.lha.*;

/**
 * LHAA[JCuWJB
 * jLHAAPIgpLZH`̃A[JCuWJB
 */
public final class LhaExpander implements Expander {

    private LhaInputStream lis;

    /**
     * LhaExpander̐B
     * @param is ̓Xg[
     */
    public LhaExpander(InputStream is) {
        this.lis = new LhaInputStream(is);
    }

    /* (overridden)
     * @see net.argius.filetool.compress.Expander#nextEntry()
     */
    public ArchiveEntry nextEntry() throws IOException {
        LhaHeader header = lis.getNextEntry();
        if (header == null) {
            return ArchiveEntry.EMPTY;
        }
        ArchiveEntry ae = new ArchiveEntry(header.getPath());
        ae.setLastModified(header.getLastModified().getTime());
        return ae;
    }

    /* (overridden)
     * @see net.argius.filetool.compress.Expander#expand(java.io.OutputStream)
     */
    public long expand(OutputStream os) throws IOException {
        return IOUtilities.transferAll(lis, os);
    }

    /* (overridden)
     * @see net.argius.filetool.compress.Expander#close()
     */
    public void close() throws IOException {
        try {
            lis.close();
        } catch (NullPointerException ex) {
            // ignore
        }
    }

}
