package net.argius.filetool;

import java.io.*;
import java.util.zip.*;

/**
 * GZIP𓀏B
 * WAPIgpGZIP`̉𓀂sB
 */
public final class GzipDecompressor extends InputStream implements Decompressor {

    private GZIPInputStream gis;

    /**
     * GzipDecompressor̐B
     * @param is ̓Xg[
     * @throws IOException o̓G[ꍇ 
     */
    public GzipDecompressor(InputStream is) throws IOException {
        this.gis = new GZIPInputStream(is);
    }

    /* (overridden)
     * @see net.argius.filetool.compress.Decompressor#decompress(java.io.InputStream)
     */
    public void decompress(OutputStream os) throws IOException {
        IOUtilities.transferAll(gis, os);
    }

    /* (overridden)
     * @see java.io.InputStream#available()
     */
    public int available() throws IOException {
        return gis.available();
    }

    /* (overridden)
     * @see java.io.InputStream#read()
     */
    public int read() throws IOException {
        return gis.read();
    }

    /* (overridden)
     * @see java.io.InputStream#read(byte[])
     */
    public int read(byte[] b) throws IOException {
        return gis.read(b);
    }

    /* (overridden)
     * @see java.io.InputStream#read(byte[], int, int)
     */
    public int read(byte[] buf, int off, int len) throws IOException {
        return gis.read(buf, off, len);
    }

    /* (overridden)
     * @see java.io.InputStream#mark(int)
     */
    public void mark(int readlimit) {
        gis.mark(readlimit);
    }

    /* (overridden)
     * @see java.io.InputStream#markSupported()
     */
    public boolean markSupported() {
        return gis.markSupported();
    }

    /* (overridden)
     * @see java.io.InputStream#reset()
     */
    public void reset() throws IOException {
        gis.reset();
    }

    /* (overridden)
     * @see java.io.InputStream#skip(long)
     */
    public long skip(long n) throws IOException {
        return gis.skip(n);
    }

    /* (overridden)
     * @see java.io.InputStream#close()
     */
    public void close() throws IOException {
        try {
            gis.close();
        } finally {
            super.close();
        }
    }

}
