package net.argius.filetool;

import java.io.*;
import java.util.zip.*;

/**
 * GZIPkB
 * WAPIgpGZIP`̈ksB
 */
public final class GzipCompressor extends OutputStream implements Compressor {

    private GZIPOutputStream gos;

    /**
     * GzipCompressor̐B
     * @param os 
     * @throws IOException 
     */
    public GzipCompressor(OutputStream os) throws IOException {
        this.gos = new GZIPOutputStream(os);
    }

    /* (overridden)
     * @see net.argius.filetool.compress.Compressor#compress(java.io.InputStream, java.io.OutputStream)
     */
    public void compress(InputStream is) throws IOException {
        IOUtilities.transferAll(is, gos);
    }

    /* (overridden)
     * @see java.io.OutputStream#write(int)
     */
    public void write(int b) throws IOException {
        gos.write(b);
    }

    /* (overridden)
     * @see java.io.OutputStream#write(byte[])
     */
    public void write(byte[] b) throws IOException {
        gos.write(b);
    }

    /* (overridden)
     * @see java.io.OutputStream#write(byte[], int, int)
     */
    public void write(byte[] b, int off, int len) throws IOException {
        gos.write(b, off, len);
    }

    /* (overridden)
     * @see java.io.OutputStream#flush()
     */
    public void flush() throws IOException {
        gos.flush();
    }

    /* (overridden)
     * @see java.io.OutputStream#close()
     */
    public void close() throws IOException {
        try {
            gos.close();
        } finally {
            super.close();
        }
    }

}
