package net.argius.filetool;

import java.io.*;

/**
 * t@CkB
 */
public final class FileCompressor {

    /**
     * t@CkB
     * o͐t@ĆAt@CɈk^Cv̊gqt̂ɂȂB
     * @param src kΏۃt@C
     * @param type k^Cv
     * @throws IOException o̓G[ꍇ 
     */
    public static void compress(File src, CompressType type) throws IOException {
        File dst;
        if (type == CompressType.GZIP) {
            dst = new File(src.getParentFile(), src.getName() + ".gz");
        } else if (type == CompressType.BZIP2) {
            dst = new File(src.getParentFile(), src.getName() + ".bz2");
        } else {
            throw new IllegalArgumentException();
        }
        compress(src, dst, type);
    }

    /**
     * t@CkB
     * k^Cv́Ao͐̊gq画ʂB
     * @param src kΏۃt@C
     * @param dst o͐t@C
     * @throws IOException o̓G[ꍇ 
     */
    public static void compress(File src, File dst) throws IOException {
        compress(src, dst, CompressType.getType(dst));
    }

    /**
     * t@CkB
     * @param src kΏۃt@C
     * @param dst o͐t@C
     * @param type k^Cv
     * @throws IOException o̓G[ꍇ 
     */
    public static void compress(File src, File dst, CompressType type) throws IOException {
        File tmp = Utilities.createTemporaryFile();
        Compressor compressor;
        if (type == CompressType.GZIP) {
            compressor = new GzipCompressor(new FileOutputStream(tmp));
        } else if (type == CompressType.BZIP2) {
            compressor = new Bzip2Compressor(new FileOutputStream(tmp));
        } else {
            throw new IllegalArgumentException();
        }
        try {
            InputStream is = new FileInputStream(src);
            try {
                compressor.compress(is);
            } finally {
                is.close();
            }
        } finally {
            compressor.close();
        }
        IOUtilities.move(tmp, dst, false);
    }

    /**
     * g̕\B
     */
    private static void printUsage() {
        PrintStream err = System.err;
        err.println("FileCompressor (argius-filetool)");
        err.println("usage : (command) src dst");
        err.println("options: none");
    }

    /**
     * FileCompressor̎sB
     * @param args p[^(see 'usage')
     */
    public static void main(String[] args) {
        if (args.length < 2) {
            printUsage();
            return;
        }
        for (int i = 0; i < args.length; i++) {
            String arg = args[i];
            if (arg.equals("-h") || arg.equals("--help")) {
                printUsage();
                return;
            }
        }
        final String commandNameInfo = "FileCompressor: ";
        int status;
        try {
            FileCompressor.compress(new File(args[0]), new File(args[1]));
            status = 0;
        } catch (IOException ex) {
            System.out.println(commandNameInfo + ex.getMessage());
            status = 1;
        } catch (Exception ex) {
            String message = ex + Utilities.getFirstStackTrace(ex, DiskUsage.class);
            System.out.println(commandNameInfo + message);
            status = 255;
        }
        if (status > 0) {
            System.exit(status);
        }
    }

}
