package net.argius.filetool;

import java.io.*;
import java.util.*;

/**
 * fBNgPʂ̃fBXNgpʌvZB
 * {IɃXbhZ[tł͂ȂA
 * IuWFNg𕡐̃Xbh瑀삵ꍇA
 * <code>getSize</code> ͏肭삷邩ȂB
 */
public class DiskUsage {

    private PrintWriter out;
    private PrintWriter err;
    private boolean messageEnables;
    private int lower;
    private int upper;

    /**
     * DiskUsage̐B
     */
    public DiskUsage() {
        this(new PrintWriter(System.out, true));
    }

    /**
     * DiskUsage̐B
     * @param out o͐
     */
    public DiskUsage(PrintWriter out) {
        this(out, new PrintWriter(System.err, true));
    }

    /**
     * DiskUsage̐B
     * @param out o͐
     * @param err bZ[Wo͐
     */
    public DiskUsage(PrintWriter out, PrintWriter err) {
        this.out = out;
        this.err = err;
        this.messageEnables = false;
        this.lower = 0;
        this.upper = Integer.MAX_VALUE;
    }

    /**
     * bZ[Wo͂LǂׂB
     * @return bZ[Wo͂Lǂ
     */
    public final boolean isMessageEnables() {
        return messageEnables;
    }

    /**
     * bZ[Wo͂Lǂ̐ݒB
     * @param enables bZ[Wo͂Lǂ
     */
    public final void setMessageEnables(boolean enables) {
        this.messageEnables = enables;
    }

    /**
     * ʂo͂[͈̔͂ݒ肷B
     * @param lower 臒l̉l
     * @param upper 臒l̏l
     */
    public final void setRange(int lower, int upper) {
        if (lower > upper || lower < 0 || upper < 0) {
            throw new IllegalArgumentException("range: " + lower + ',' + upper);
        }
        this.lower = lower;
        this.upper = upper;
    }

    /**
     * ̏óB
     * @param size TCY
     * @param depth [
     * @param file t@C
     */
    public void printInfo(long size, int depth, File file) {
        StringBuffer buffer = new StringBuffer();
        int p1length = String.valueOf(size).length();
        if (p1length < 19) {
            buffer.append("                   ".substring(p1length));
        }
        buffer.append(size);
        buffer.append('\t');
        int p2length = String.valueOf(depth).length();
        if (p2length < 2) {
            buffer.append("  ".substring(p2length));
        }
        buffer.append(depth);
        buffer.append('\t');
        buffer.append(file.getPath());
        out.println(buffer);
    }

    /**
     * bZ[W̏óB
     * @param object IuWFNg
     */
    public void printMessage(Object object) {
        if (messageEnables) {
            err.println(" ... scanning " + object);
        }
    }

    /**
     * o͂Lɂ邩ǂׂB
     * @param pw PrintWriter(out or err)
     * @param file ݂̃t@C
     * @param depth ݂̃t@C̐[
     * @return o͂Lɂꍇ <code>true</code> AłȂ <code>false</code>
     */
    protected boolean isOutputEnables(PrintWriter pw, File file, int depth) {
        if (pw == out && isInRange(depth)) {
            return true;
        } else if (pw == err) {
            return (upper - lower < 2) || (lower <= depth && depth < upper);
        }
        return false;
    }

    /**
     * [̎擾B
     * @param file t@C
     * @return [
     */
    protected int getDepth(File file) {
        String path = file.getPath().replace(File.separatorChar, '/');
        if (path.endsWith(String.valueOf('/'))) {
            path = path.substring(0, path.length() - 1);
        }
        int count = 0;
        int index = 0;
        while (true) {
            index = path.indexOf('/', index);
            if (index >= 0) {
                ++count;
                ++index;
            } else {
                break;
            }
        }
        return count;
    }

    /**
     * [͈͓ǂׂB
     * @param depth [
     * @return [͈͓Ȃ <code>true</code> AłȂ <code>false</code>
     */
    protected final boolean isInRange(int depth) {
        return (lower <= depth && depth <= upper);
    }

    /**
     * fBXNgpʏ̏óB
     * @param file Ώۃt@C/fBNg
     * @return Ώۃt@C/fBNg̃fBXNgp
     */
    public final long output(File file) {
        if (!file.isDirectory()) {
            return file.length();
        }
        int depth = getDepth(file);
        long size = 0;
        File[] files = file.listFiles();
        if (messageEnables && isOutputEnables(err, file, depth)) {
            printMessage(file);
        }
        if (files != null) {
            for (int i = 0; i < files.length; i++) {
                File child = files[i];
                size += output(child);
            }
        }
        if (isOutputEnables(out, file, depth)) {
            printInfo(size, depth, file);
        }
        return size;
    }

    /**
     * fBXNgpʂ̎擾B
     * @param file Ώۃt@C/fBNg
     * @return Ώۃt@C/fBNg̃fBXNgp
     */
    public final long getSize(File file) {
        if (!file.isDirectory()) {
            return file.length();
        }
        long size = 0;
        File[] files = file.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; i++) {
                File child = files[i];
                size += getSize(child);
            }
        }
        return size;
    }

    /**
     * NB
     * @param args p[^
     */
    private static void invoke(String[] args) {
        DiskUsage du = new DiskUsage();
        du.setMessageEnables(true);
        du.setRange(0, 3);
        boolean onlyTotal = false;
        List pathList = new ArrayList();
        for (int i = 0; i < args.length; i++) {
            String arg = args[i];
            if (arg.startsWith("-")) {
                if (arg.equals("-q") || arg.equals("--quit")) {
                    du.setMessageEnables(false);
                } else if (arg.equals("--total")) {
                    onlyTotal = true;
                } else if (arg.equals("-r") || arg.equals("--range")) {
                    i += 2;
                    if (args.length <= i) {
                        throw new IllegalArgumentException("invalid option: range requires 2 parameters");
                    }
                    int lower;
                    int upper;
                    try {
                        lower = Integer.parseInt(args[i - 1]);
                        upper = Integer.parseInt(args[i]);
                    } catch (NumberFormatException ex) {
                        throw new IllegalArgumentException("invalid range parameter: "
                                                           + ex.getMessage());
                    }
                    du.setRange(lower, upper);
                } else {
                    throw new IllegalArgumentException("invalid option: " + arg);
                }
            } else {
                pathList.add(arg);
            }
        }
        // main
        for (int i = 0, n = pathList.size(); i < n; i++) {
            File file = new File(((String)pathList.get(i)));
            if (onlyTotal) {
                long size = du.getSize(file);
                StringBuffer buffer = new StringBuffer();
                int p1length = String.valueOf(size).length();
                if (p1length < 19) {
                    buffer.append("                   ".substring(p1length));
                }
                buffer.append(size);
                buffer.append('\t');
                buffer.append(file.getPath());
                System.out.println(buffer);
            } else {
                du.output(file);
            }
        }
    }

    /**
     * g̕\B
     */
    private static void printUsage() {
        PrintStream err = System.err;
        err.println("DiskUsage (argius-filetool)");
        err.println("usage : (command) [path...]");
        err.println("options: ");
        err.println("  -q, --quit   suppress messages");
        err.println("  -r, --range  setting range to show infos and messages");
        err.println("      --total  do print total size only");
        err.println("  -h, --help   show (this) help");
    }

    /**
     * DiskUsage̎sB
     * @param args p[^(see 'usage')
     */
    public static void main(String[] args) {
        if (args.length == 0) {
            printUsage();
            return;
        }
        for (int i = 0; i < args.length; i++) {
            String arg = args[i];
            if (arg.equals("-h") || arg.equals("--help")) {
                printUsage();
                return;
            }
        }
        int status;
        try {
            invoke(args);
            status = 0;
        } catch (Exception ex) {
            String message = ex + Utilities.getFirstStackTrace(ex, DiskUsage.class);
            System.out.println("DiskUsage: " + message);
            status = 255;
        }
        if (status > 0) {
            System.exit(status);
        }
    }

}
