package net.argius.filetool;

import junit.framework.*;

/**
 * 
 */
public class FileSizeTest extends TestCase {

    /**
     * Test method for {@link net.argius.filetool.FileSize#toLong(java.lang.String)}.
     */
    public void testToLong() {
        doTest_toLong(15L, "15");
        doTest_toLong(38L, "38.0");
        // block
        doTest_toLong(1536L, "3B");
        doTest_toLong(256L, "0.5b");
        doTest_toLong(6320987597312L, "12345678901B");
        // K
        doTest_toLong(16000L, "16K");
        doTest_toLong(8330L, "8.33k");
        // KB
        doTest_toLong(16384L, "16KB");
        doTest_toLong(22937L, "22.4kb");
        // M
        doTest_toLong(98000000L, "98M");
        doTest_toLong(33300000L, "33.3m");
        // MB
        doTest_toLong(17825792L, "17MB");
        doTest_toLong(27577548L, "26.3mb");
        // G
        doTest_toLong(8000000000L, "8G");
        doTest_toLong(43200000000L, "43.2g");
        // GB
        doTest_toLong(73014444032L, "68GB");
        doTest_toLong(4133906022L, "3.85gb");
        // T
        doTest_toLong(3000000000000L, "3T");
        doTest_toLong(1009000000000L, "1.009t");
        // TB
        doTest_toLong(14293651161088L, "13TB");
        doTest_toLong(912594651054L, "0.83tb");
        // P
        doTest_toLong(4000000000000000L, "4P");
        doTest_toLong(201000000000000L, "0.201p");
        // PE
        doTest_toLong(10133099161583616L, "9PB");
        doTest_toLong(1553741871442821L, "1.38pb");
        // E
        doTest_toLong(7000000000000000000L, "7E");
        doTest_toLong(30000000000000000L, "0.03e");
        // EB
        doTest_toLong(6917529027641081856L, "6EB");
        doTest_toLong(3816170180248663490L, "3.31eb");
        // Z
        doTest_toLong(3000000000000000000L, "0.003z");
        // ZB
        doTest_toLong(5902958103587056517L, "0.005ZB");
        // Y
        doTest_toLong(900000000000000000L, "0.0000009y");
        // YB
        doTest_toLong(1063854721260873673L, "0.00000088YB");
        // threshold
        doTest_toLong(9223372025325560761L, "7.99999999EB");
        try {
            FileSize.toLong("8EB");
            fail();
        } catch (Exception ex) {
            // OK
        }
        // error
        String[] errorPatterns = {"15.1", "0.0.0K", "3cB", "9EB", "5Z", "6zb", "7Y", "8yB", "x",
                                  "-1"};
        for (int i = 0; i < errorPatterns.length; i++) {
            String pattern = errorPatterns[i];
            try {
                FileSize.toLong(pattern);
                fail("does not fail: " + pattern);
            } catch (IllegalArgumentException ex) {
                System.out.println(ex); // OK
            }
            try {
                FileSize.toLong(pattern.toUpperCase());
                fail("does not fail: " + pattern);
            } catch (IllegalArgumentException ex) {
                System.out.println(ex); // OK
            }
            try {
                FileSize.toLong(pattern.toLowerCase());
                fail("does not fail: " + pattern);
            } catch (IllegalArgumentException ex) {
                System.out.println(ex); // OK
            }
        }
        TestHelper.callPrivateConstructor(FileSize.class);
    }

    private static void doTest_toLong(long expect, String expression) {
        long result = FileSize.toLong(expression);
        assertTrue("negative value: " + result + ", " + expression, result >= 0);
        assertEquals(expect, result);
        assertEquals(result, FileSize.toLong(expression.toUpperCase()));
        assertEquals(result, FileSize.toLong(expression.toLowerCase()));
    }

}
