package net.argius.filetool;

import junit.framework.*;

/**
 * ArchiveEntrỹeXgB
 */
public class ArchiveEntryTest extends TestCase {

    private static final String[] PATHS = {"test", "aa", "dir/test1", "DIR/", "dir/a/GGGG/"};

    /**
     * Test method for {@link net.argius.filetool.ArchiveEntry#ArchiveEntry(java.lang.String)}.
     */
    public void testArchiveEntry() {
        // skip
    }

    /**
     * Test method for {@link net.argius.filetool.ArchiveEntry#getName()}.
     */
    public void testGetName() {
        for (int i = 0; i < PATHS.length; i++) {
            String path = PATHS[i];
            ArchiveEntry entry = new ArchiveEntry(path);
            assertEquals(path, entry.getName());
        }
    }

    /**
     * Test method for {@link net.argius.filetool.ArchiveEntry#setName(java.lang.String)}.
     */
    public void testSetName() {
        for (int i = 0; i < PATHS.length; i++) {
            String path = PATHS[i];
            ArchiveEntry entry = new ArchiveEntry("1");
            entry.setName(path);
            assertEquals(path, entry.getName());
        }
    }

    /**
     * Test method for {@link net.argius.filetool.ArchiveEntry#getLastModified()}.
     */
    public void testGetLastModified() {
        for (int i = 0; i < PATHS.length; i++) {
            long lastModified = 32525234L;
            ArchiveEntry entry = new ArchiveEntry(PATHS[i]);
            entry.setLastModified(lastModified);
            assertEquals(lastModified, entry.getLastModified());
        }
    }

    /**
     * Test method for {@link net.argius.filetool.ArchiveEntry#setLastModified(long)}.
     */
    public void testSetLastModified() {
        // skip
    }

    /**
     * Test method for {@link net.argius.filetool.ArchiveEntry#isDirectory()}.
     */
    public void testIsDirectory() {
        for (int i = 0; i < PATHS.length; i++) {
            String path = PATHS[i];
            ArchiveEntry entry = new ArchiveEntry(path);
            assertEquals(path.endsWith("/"), entry.isDirectory());
        }
    }

    /**
     * Test method for {@link net.argius.filetool.ArchiveEntry#toString()}.
     */
    public void testToString() {
        for (int i = 0; i < PATHS.length; i++) {
            String path = PATHS[i];
            ArchiveEntry entry = new ArchiveEntry(path);
            String s = path
                       + ' '
                       + entry.getLastModified()
                       + (path.endsWith("/") ? " (directory)" : "");
            assertEquals(s, entry.toString());
        }
    }

}
