import java.io.*;

import net.argius.filetool.*;

public class ArchiverSample {

    public static void main(String[] args) {
        try {
            // tar cf archive.tar dir/
            FileArchiver archiver = new FileArchiver(new File("archive.tar"));
            try {
                archiver.archive(new File("dir/"));
            } finally {
                archiver.close();
            }
        } catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        try {
            // tar xf archiver.tar -C out/ 
            FileExpander expander = new FileExpander(new File("archive.tar"));
            try {
                expander.expand(new File("out/"));
            } finally {
                expander.close();
            }
        } catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        try {
            // cat archive.tar | gzip > archive.tar
            FileCompressor.compress(new File("archive.tar"), CompressType.GZIP);
        } catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        try {
            // gunzip -c archive.tar.gz > x.tar
            FileDecompressor.decompress(new File("archive.tar.gz"), new File("x.tar"));
        } catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        try {
            // tar cf - dir/ | gzip > archive.tar.gz
            FileArchiver archiver = new FileArchiver(new File("archive.tar.gz"));
            try {
                archiver.archive(new File("dir/"));
            } finally {
                archiver.close();
            }
        } catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        try {
            // gunzip -c archive.tar.gz | tar xf - -C out/ 
            FileExpander expander = new FileExpander(new File("archive.tar.gz"));
            try {
                expander.expand(new File("out/"));
            } finally {
                expander.close();
            }
        } catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

}
