/*
 * Decompiled with CFR 0.152.
 */
package net.argius.filetool.compress;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import net.argius.filetool.IOUtilities;
import net.argius.filetool.compress.Archiver;
import net.argius.filetool.compress.ArchiverEntry;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;

public final class ZipArchiver
implements Archiver {
    private final ZipOutputStream zos;
    private boolean includesDirectory;

    public ZipArchiver(OutputStream outputStream) {
        this.zos = new ZipOutputStream(outputStream);
    }

    public void setIncludesDirectory(boolean bl) {
        this.includesDirectory = bl;
    }

    public void addEntry(ArchiverEntry archiverEntry, InputStream inputStream, long l) throws IOException {
        if (archiverEntry.isDirectory()) {
            if (this.includesDirectory) {
                ZipEntry zipEntry = new ZipEntry(archiverEntry.getName());
                this.zos.putNextEntry(zipEntry);
                zipEntry.setMethod(0);
                zipEntry.setCrc(0L);
                zipEntry.setSize(0L);
                zipEntry.setCompressedSize(0L);
                zipEntry.setTime(archiverEntry.getLastModified());
                this.zos.closeEntry();
            }
        } else {
            ZipEntry zipEntry = new ZipEntry(archiverEntry.getName());
            this.zos.putNextEntry(zipEntry);
            CheckedInputStream checkedInputStream = new CheckedInputStream(inputStream, new CRC32());
            long l2 = IOUtilities.transferAll(inputStream, (OutputStream)this.zos);
            zipEntry.setCrc(checkedInputStream.getChecksum().getValue());
            zipEntry.setSize(l2);
            zipEntry.setCompressedSize(l2);
            zipEntry.setTime(archiverEntry.getLastModified());
            this.zos.closeEntry();
        }
    }

    public void close() throws IOException {
        this.zos.close();
    }
}

