/*
 * Decompiled with CFR 0.152.
 */
package net.argius.filetool.compress;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import jp.gr.java_conf.dangan.util.lha.LhaHeader;
import jp.gr.java_conf.dangan.util.lha.LhaOutputStream;
import net.argius.filetool.IOUtilities;
import net.argius.filetool.compress.Archiver;
import net.argius.filetool.compress.ArchiverEntry;

public final class LhaArchiver
implements Archiver {
    private final LhaOutputStream los;
    private boolean includesDirectory;

    public LhaArchiver(OutputStream outputStream) {
        this.los = new LhaOutputStream(outputStream);
        this.includesDirectory = true;
    }

    public void setIncludesDirectory(boolean bl) {
        this.includesDirectory = bl;
    }

    public void addEntry(ArchiverEntry archiverEntry, InputStream inputStream, long l) throws IOException {
        if (archiverEntry.isDirectory()) {
            if (this.includesDirectory) {
                LhaHeader lhaHeader = new LhaHeader(archiverEntry.getName());
                lhaHeader.setCRC(0);
                lhaHeader.setOriginalSize(0L);
                lhaHeader.setCompressedSize(0L);
                lhaHeader.setLastModified(new Date(archiverEntry.getLastModified()));
                this.los.putNextEntry(lhaHeader);
                this.los.closeEntry();
            }
        } else {
            LhaHeader lhaHeader = new LhaHeader(archiverEntry.getName());
            this.los.putNextEntry(lhaHeader);
            CheckedInputStream checkedInputStream = new CheckedInputStream(inputStream, new CRC32());
            long l2 = IOUtilities.transferAll(checkedInputStream, (OutputStream)this.los);
            lhaHeader.setCRC((int)checkedInputStream.getChecksum().getValue());
            lhaHeader.setOriginalSize(l2);
            lhaHeader.setCompressedSize(l2);
            lhaHeader.setLastModified(new Date(archiverEntry.getLastModified()));
            this.los.closeEntry();
        }
    }

    public void close() throws IOException {
        this.los.close();
    }
}

