/*
 * Decompiled with CFR 0.152.
 */
package net.argius.filetool;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.argius.filetool.ArchiveEntry;
import net.argius.filetool.Expander;
import net.argius.filetool.IOUtilities;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;

public final class TarExpander
implements Expander {
    private TarInputStream tis;

    public TarExpander(InputStream inputStream) {
        this.tis = new TarInputStream(inputStream);
    }

    public ArchiveEntry nextEntry() throws IOException {
        TarEntry tarEntry = this.tis.getNextEntry();
        if (tarEntry == null) {
            return ArchiveEntry.EMPTY;
        }
        ArchiveEntry archiveEntry = new ArchiveEntry(tarEntry.getName());
        archiveEntry.setLastModified(tarEntry.getModTime().getTime());
        return archiveEntry;
    }

    public long expand(OutputStream outputStream) throws IOException {
        return IOUtilities.transferAll((InputStream)this.tis, outputStream);
    }

    public void close() throws IOException {
        this.tis.close();
    }
}

