/*
 * Decompiled with CFR 0.152.
 */
package net.argius.filetool;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.argius.filetool.ArchiveEntry;
import net.argius.filetool.Archiver;
import net.argius.filetool.IOUtilities;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarOutputStream;

public final class TarArchiver
implements Archiver {
    private TarOutputStream tos;
    private boolean includesDirectory;

    public TarArchiver(OutputStream outputStream) {
        this.tos = new TarOutputStream(outputStream);
        this.includesDirectory = true;
    }

    public void setIncludesDirectory(boolean bl) {
        this.includesDirectory = bl;
    }

    public void addEntry(ArchiveEntry archiveEntry, InputStream inputStream, long l) throws IOException {
        if (archiveEntry.isDirectory()) {
            if (this.includesDirectory) {
                TarEntry tarEntry = new TarEntry(archiveEntry.getName());
                tarEntry.setMode(16877);
                tarEntry.setModTime(archiveEntry.getLastModified());
                this.tos.putNextEntry(tarEntry);
                this.tos.closeEntry();
            }
        } else {
            TarEntry tarEntry = new TarEntry(archiveEntry.getName());
            tarEntry.setSize(l);
            tarEntry.setModTime(archiveEntry.getLastModified());
            this.tos.putNextEntry(tarEntry);
            IOUtilities.transferAll(inputStream, (OutputStream)this.tos);
            this.tos.closeEntry();
        }
    }

    public void close() throws IOException {
        this.tos.close();
    }
}

