/*
 * Decompiled with CFR 0.152.
 */
package net.argius.filetool;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import net.argius.filetool.FileSize;
import net.argius.filetool.IOUtilities;
import net.argius.filetool.Utilities;

public class Split {
    private final long size;
    private final String prefix;
    private final int suffixLength;
    private final boolean numericSuffix;
    private boolean verbose;
    static /* synthetic */ Class class$net$argius$filetool$Concatenation;

    public Split(long l, String string, int n, boolean bl) {
        if (l < 1L) {
            throw new IllegalArgumentException("size: " + l);
        }
        if (string == null) {
            throw new IllegalArgumentException("prefix: null");
        }
        this.size = l;
        this.prefix = string;
        this.suffixLength = n;
        this.numericSuffix = bl;
        this.verbose = false;
    }

    public final boolean isVerbose() {
        return this.verbose;
    }

    public final void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    protected void printInfo(Object object) {
        System.out.println(object);
    }

    protected String getFileName(int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.prefix);
        if (this.numericSuffix) {
            int n2 = this.suffixLength - String.valueOf(n).length();
            for (int i = 0; i < n2; ++i) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n);
        } else {
            int n3;
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append(Integer.toString(n, 26));
            int n4 = stringBuffer2.length();
            for (n3 = 0; n3 < n4; ++n3) {
                char c = stringBuffer2.charAt(n3);
                if ('0' <= c && c <= '9') {
                    c = (char)(c + 49);
                } else if ('a' <= c && c <= 'z') {
                    c = (char)(c + 10);
                }
                stringBuffer2.setCharAt(n3, c);
            }
            if (stringBuffer2.length() > this.suffixLength) {
                throw new IOException("Output file suffixes exhausted");
            }
            n4 = this.suffixLength - stringBuffer2.length();
            for (n3 = 0; n3 < n4; ++n3) {
                stringBuffer2.insert(0, 'a');
            }
            stringBuffer.append(stringBuffer2);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(InputStream inputStream) throws IOException {
        long l;
        int n = 0;
        do {
            File file;
            File file2 = File.createTempFile("split", ".tmp");
            file2.deleteOnExit();
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            try {
                l = IOUtilities.transfer(inputStream, fileOutputStream, this.size);
            }
            finally {
                ((OutputStream)fileOutputStream).close();
            }
            if (l <= 0L) continue;
            String string = this.getFileName(n);
            if (this.verbose) {
                this.printInfo("file=" + string + ", " + l + " bytes");
            }
            if ((file = new File(string)).exists()) {
                file.delete();
            }
            file2.renameTo(file);
            ++n;
        } while (l >= this.size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void invoke(String[] stringArray) throws IOException {
        Object object;
        long l = 1024L;
        String string = "x";
        int n = 2;
        boolean bl = false;
        boolean bl2 = false;
        String string2 = "";
        int n2 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i];
            if (((String)object).startsWith("-") && ((String)object).length() > 1) {
                if (((String)object).equals("-a") || ((String)object).equals("--suffix-length")) {
                    if (stringArray.length <= ++i) {
                        throw new IllegalArgumentException("option '" + (String)object + "' require 1 parameter");
                    }
                    boolean bl3 = false;
                    try {
                        n = Integer.parseInt(stringArray[i]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl3 = true;
                    }
                    if (n < 1) {
                        bl3 = true;
                    }
                    if (!bl3) continue;
                    throw new IllegalArgumentException("invalid option: " + (String)object + ' ' + stringArray[i]);
                }
                if (((String)object).equals("-b") || ((String)object).equals("--bytes")) {
                    if (stringArray.length <= ++i) {
                        throw new IllegalArgumentException("option '" + (String)object + "' require 1 parameter");
                    }
                    l = FileSize.toLong(stringArray[i]);
                    continue;
                }
                if (((String)object).equals("-d") || ((String)object).equals("--numeric-suffixes")) {
                    bl = true;
                    continue;
                }
                if (((String)object).equals("--verbose")) {
                    bl2 = true;
                    continue;
                }
                throw new IllegalArgumentException("invalid option: " + (String)object);
            }
            if (++n2 == 1) {
                string2 = object;
                continue;
            }
            if (n2 != 2) continue;
            string = object;
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("requre input file");
        }
        if (n2 > 2) {
            throw new IllegalArgumentException("too much arguments: ");
        }
        Split split = new Split(l, string, n, bl);
        split.setVerbose(bl2);
        if (string2.equals("-")) {
            split.execute(System.in);
        } else {
            object = new File(string2);
            if (!((File)object).exists() || !((File)object).isFile()) {
                throw new FileNotFoundException(string2);
            }
            FileInputStream fileInputStream = new FileInputStream((File)object);
            try {
                split.execute(fileInputStream);
            }
            finally {
                ((InputStream)fileInputStream).close();
            }
        }
    }

    private static void printUsage() {
        PrintStream printStream = System.err;
        printStream.println("Split (argius-filetool)");
        printStream.println("usage : (command) [options] input [prefix]");
        printStream.println("options: ");
        printStream.println("  -a, --suffix-length=N   set suffix length (2)");
        printStream.println("  -b, --bytes=SIZE        split by SIZE bytes");
        printStream.println("  -d, --numeric-suffixes  use numeric suffix instead of alphabetic");
        printStream.println("      --verbose           verbose message mode");
        printStream.println("  -h, --help              show (this) help");
    }

    public static void main(String[] stringArray) {
        int n;
        if (stringArray.length == 0) {
            Split.printUsage();
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!string.equals("-h") && !string.equals("--help")) continue;
            Split.printUsage();
            return;
        }
        try {
            Split.invoke(stringArray);
            n = 0;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("Split: " + illegalArgumentException.getMessage());
            n = 1;
        }
        catch (IOException iOException) {
            System.out.println("Split: " + iOException.getMessage());
            n = 1;
        }
        catch (Exception exception) {
            String string = exception + Utilities.getFirstStackTrace(exception, class$net$argius$filetool$Concatenation == null ? (class$net$argius$filetool$Concatenation = Split.class$("net.argius.filetool.Concatenation")) : class$net$argius$filetool$Concatenation);
            System.out.println("Split: " + string);
            n = 255;
        }
        if (n > 0) {
            System.exit(n);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

