/*
 * Decompiled with CFR 0.152.
 */
package net.argius.filetool;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jp.gr.java_conf.dangan.util.lha.LhaHeader;
import jp.gr.java_conf.dangan.util.lha.LhaInputStream;
import net.argius.filetool.ArchiveEntry;
import net.argius.filetool.Expander;
import net.argius.filetool.IOUtilities;

public final class LhaExpander
implements Expander {
    private LhaInputStream lis;

    public LhaExpander(InputStream inputStream) {
        this.lis = new LhaInputStream(inputStream);
    }

    public ArchiveEntry nextEntry() throws IOException {
        LhaHeader lhaHeader = this.lis.getNextEntry();
        if (lhaHeader == null) {
            return ArchiveEntry.EMPTY;
        }
        ArchiveEntry archiveEntry = new ArchiveEntry(lhaHeader.getPath());
        archiveEntry.setLastModified(lhaHeader.getLastModified().getTime());
        return archiveEntry;
    }

    public long expand(OutputStream outputStream) throws IOException {
        return IOUtilities.transferAll((InputStream)this.lis, outputStream);
    }

    public void close() throws IOException {
        try {
            this.lis.close();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

