/*
 * Decompiled with CFR 0.152.
 */
package net.argius.filetool;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import net.argius.filetool.Decompressor;
import net.argius.filetool.IOUtilities;

public final class GzipDecompressor
extends InputStream
implements Decompressor {
    private GZIPInputStream gis;

    public GzipDecompressor(InputStream inputStream) throws IOException {
        this.gis = new GZIPInputStream(inputStream);
    }

    public void decompress(OutputStream outputStream) throws IOException {
        IOUtilities.transferAll(this.gis, outputStream);
    }

    public int available() throws IOException {
        return this.gis.available();
    }

    public int read() throws IOException {
        return this.gis.read();
    }

    public int read(byte[] byArray) throws IOException {
        return this.gis.read(byArray);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.gis.read(byArray, n, n2);
    }

    public void mark(int n) {
        this.gis.mark(n);
    }

    public boolean markSupported() {
        return this.gis.markSupported();
    }

    public void reset() throws IOException {
        this.gis.reset();
    }

    public long skip(long l) throws IOException {
        return this.gis.skip(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.gis.close();
        }
        finally {
            super.close();
        }
    }
}

